/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappings;

import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.exception.OpcuaDataValueStatusException;
import com.cumulocity.opcua.common.model.mapping.MatchingCondition;
import com.cumulocity.opcua.common.model.mapping.MatchingNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Attributes;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class NodeMatcher {
    private static final Logger log = LoggerFactory.getLogger(NodeMatcher.class);

    NodeMatcher() {
    }

    static boolean nonMatchNodeIdsConstraint(String rootNodeId, NamespaceTable namespaceTable, Collection<String> nodeIdsConstraint) {
        if (!CollectionUtils.isEmpty(nodeIdsConstraint)) {
            return nodeIdsConstraint.stream().noneMatch(nodeId -> NodeIds.nodeIdEquals((NamespaceTable)namespaceTable, (String)nodeId, (String)rootNodeId));
        }
        return false;
    }

    static boolean matchServerWithNodeValues(OpcuaClient client, MatchingCondition condition) {
        return NodeMatcher.matchAll((OpcuaClient)client, (Collection)condition.getMatchAll()) && NodeMatcher.matchOneOf((OpcuaClient)client, (Collection)condition.getMatchOneOf());
    }

    static boolean nonSupportsValueAttribute(OpcuaClient client, String nodeId) {
        try {
            return !client.supportsAttribute(nodeId, Attributes.Value);
        }
        catch (Throwable e) {
            log.warn("Unable to determine whether Value attribute is supported or not, reason: {}, assuming yes", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean matchAll(OpcuaClient client, Collection<MatchingNode> matchingAll) {
        if (CollectionUtils.isEmpty(matchingAll)) {
            return true;
        }
        for (MatchingNode constraint : matchingAll) {
            if (NodeMatcher.matches((OpcuaClient)client, (MatchingNode)constraint)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchOneOf(OpcuaClient client, Collection<MatchingNode> matchingOneOf) {
        if (CollectionUtils.isEmpty(matchingOneOf)) {
            return true;
        }
        for (MatchingNode constraint : matchingOneOf) {
            if (!NodeMatcher.matches((OpcuaClient)client, (MatchingNode)constraint)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(OpcuaClient client, MatchingNode constraint) {
        if (CollectionUtils.isEmpty((Collection)constraint.getValueMatchesOneOf())) {
            return client.doesNodeExist(NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)constraint.getNodeId()));
        }
        Optional actualNodeValue = NodeMatcher.getNodeValueSafely((OpcuaClient)client, (String)NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)constraint.getNodeId()));
        return actualNodeValue.isPresent() && constraint.getValueMatchesOneOf().contains(actualNodeValue.get().toString());
    }

    private static Optional<Object> getNodeValueSafely(OpcuaClient client, String nodeId) {
        try {
            DataValue dataValue = client.readValue(nodeId, Double.valueOf(0.0));
            if (Objects.nonNull(dataValue.getValue())) {
                if (log.isDebugEnabled()) {
                    log.debug("Node: {}, value: {}", (Object)nodeId, (Object)dataValue.getValue());
                }
                return Optional.ofNullable(dataValue.getValue().getValue());
            }
            return Optional.empty();
        }
        catch (OpcuaClientException | OpcuaDataValueStatusException e) {
            log.error("Unable to read node value for matching: {}, reason: {}", (Object)nodeId, (Object)e.getMessage());
            return Optional.empty();
        }
    }
}

