/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jmx.support.ConnectorServerFactoryBean;
import org.springframework.remoting.rmi.RmiRegistryFactoryBean;

@Configuration
public class RmiConfiguration {
    @Value(value="${jmx.rmi.host:localhost}")
    private String rmiHost;
    @Value(value="${jmx.rmi.port:1099}")
    private Integer rmiPort;
    @Value(value="${jmx.rmi.remote.enabled:false}")
    private boolean jmxRemoteEnabled;

    @Bean
    @ConditionalOnProperty(value={"spring.jmx.enabled"})
    public RmiRegistryFactoryBean rmiRegistry() {
        RmiRegistryFactoryBean rmiRegistryFactoryBean = new RmiRegistryFactoryBean();
        rmiRegistryFactoryBean.setPort(this.rmiPort.intValue());
        rmiRegistryFactoryBean.setAlwaysCreate(true);
        return rmiRegistryFactoryBean;
    }

    @Bean
    @ConditionalOnBean(value={RmiRegistryFactoryBean.class})
    @DependsOn(value={"rmiRegistry"})
    public ConnectorServerFactoryBean connectorServerFactoryBean() throws Exception {
        ConnectorServerFactoryBean connectorServerFactoryBean = new ConnectorServerFactoryBean();
        connectorServerFactoryBean.setObjectName((Object)"connector:name=rmi");
        connectorServerFactoryBean.setEnvironment(this.jmxProperties());
        connectorServerFactoryBean.setServiceUrl(String.format("service:jmx:rmi://%s:%s/jndi/rmi://%s:%s/jmxrmi", this.rmiHost, this.rmiPort, this.rmiHost, this.rmiPort));
        return connectorServerFactoryBean;
    }

    private Properties jmxProperties() {
        Properties properties = new Properties();
        if (this.jmxRemoteEnabled) {
            properties.setProperty("com.sun.management.jmxremote", "");
            properties.setProperty("com.sun.management.jmxremote.authenticate", Boolean.FALSE.toString());
            properties.setProperty("com.sun.management.jmxremote.ssl", Boolean.FALSE.toString());
            properties.setProperty("com.sun.management.jmxremote.port", this.rmiPort.toString());
            properties.setProperty("com.sun.management.jmxremote.rmi.port", this.rmiPort.toString());
            properties.setProperty("java.rmi.server.hostname", this.rmiHost);
        }
        return properties;
    }
}

