/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.addressspace.service;

import c8y.ua.Node;
import com.cumulocity.model.ID;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.addressspace.exception.AddressSpaceInventorySyncException;
import com.cumulocity.opcua.client.gateway.addressspace.service.synchronizer.Synchronizer;
import com.cumulocity.opcua.client.gateway.platform.repository.IdentityRepository;
import com.cumulocity.opcua.common.IdentityUtils;
import com.cumulocity.opcua.common.repository.AddressSpaceRepository;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.opcua.common.repository.filter.AddressSpaceUnorderedSubTreeInvFilter;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.inventory.PagedManagedObjectCollectionRepresentation;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.io.UnsupportedEncodingException;
import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class AddressSpaceInventoryService
extends Synchronizer {
    private static final Logger log = LoggerFactory.getLogger(AddressSpaceInventoryService.class);
    private final InventoryRepository inventoryRepository;
    private final IdentityRepository identityRepository;
    private final AddressSpaceRepository addressSpaceRepository;
    private final ThreadPoolTaskExecutor executor;
    @Value(value="${executor.threadpool.coreSize:5}")
    private int threads;
    private Clock clock = Clock.systemDefaultZone();

    @Autowired
    public AddressSpaceInventoryService(InventoryRepository inventoryRepository, IdentityRepository identityRepository, AddressSpaceRepository addressSpaceRepository, ThreadPoolTaskExecutor executor) {
        this.inventoryRepository = inventoryRepository;
        this.identityRepository = identityRepository;
        this.addressSpaceRepository = addressSpaceRepository;
        this.executor = executor;
    }

    public void syncAndStoreAddressSpace(Queue<Node> queue, Node startNode, NamespaceTable namespaceTable, GId serverId, int operationTimeoutInMinutes) throws AddressSpaceInventorySyncException, InterruptedException {
        Map existingASSubtreeMosMap = this.findExistingAddressSpaceObjects(serverId, namespaceTable, startNode);
        ConcurrentHashMap syncedAddressSpaceMosMap = new ConcurrentHashMap();
        int startNodeAncestorSize = startNode.getAncestorNodeIds() != null ? startNode.getAncestorNodeIds().size() : 1;
        long start = this.clock.millis();
        this.removeParentChildRefIfStartNodeParentChanged((ManagedObjectRepresentation)existingASSubtreeMosMap.get(startNode.getNodeId()), namespaceTable, serverId, startNode);
        if (this.threads < 1) {
            this.threads = 1;
        }
        HashSet<Future> syncJobs = new HashSet<Future>();
        for (int i = 0; i < this.threads; ++i) {
            Future future2 = this.executor.submit(() -> {
                while (!queue.isEmpty()) {
                    Optional nodeMoMaybe;
                    Node node = (Node)queue.poll();
                    if (node == null) continue;
                    if (!existingASSubtreeMosMap.containsKey(node.getNodeId()) && node.getAncestorNodeIds().size() > startNodeAncestorSize && (nodeMoMaybe = this.addressSpaceRepository.findNodeMo(namespaceTable, serverId.getValue(), node.getNodeId())).isPresent()) {
                        existingASSubtreeMosMap.put(node.getNodeId(), (ManagedObjectRepresentation)nodeMoMaybe.get());
                    }
                    this.trySyncNode(node, serverId, existingASSubtreeMosMap, syncedAddressSpaceMosMap);
                }
            });
            syncJobs.add(future2);
        }
        log.info("Thread scheduling time: " + (this.clock.millis() - start));
        start = this.clock.millis();
        long timeoutInMils = operationTimeoutInMinutes * 60 * 1000;
        while (!queue.isEmpty()) {
            log.info("Nodes left: " + queue.size());
            if (this.clock.millis() - start > timeoutInMils) {
                this.cancelSyncJobs(syncJobs);
                throw new AddressSpaceInventorySyncException(String.format("Timed out during scan address space after %s minutes", operationTimeoutInMinutes));
            }
            if (syncJobs.stream().anyMatch(future -> future.isCancelled() || future.isDone()) && !queue.isEmpty()) {
                this.cancelSyncJobs(syncJobs);
                throw new AddressSpaceInventorySyncException("One or more jobs to synchronizing address space to Platform have failed, check agent logs for more information");
            }
            Thread.sleep(2000L);
        }
        log.info("Synchronization time: " + (this.clock.millis() - start));
        this.waitForExecution(syncJobs);
        start = this.clock.millis();
        existingASSubtreeMosMap.keySet().removeAll(syncedAddressSpaceMosMap.keySet());
        for (String key : existingASSubtreeMosMap.keySet()) {
            ManagedObjectRepresentation toRemoveMo = (ManagedObjectRepresentation)existingASSubtreeMosMap.get(key);
            this.deleteIfSafe(startNode, namespaceTable, serverId, toRemoveMo);
        }
        log.info("Deletion time: " + (this.clock.millis() - start));
    }

    private void waitForExecution(Collection<Future<?>> syncJobs) {
        for (Future<?> job : syncJobs) {
            try {
                job.get();
            }
            catch (Exception e) {
                log.warn("Error while synchronizing nodes: " + e.getMessage());
            }
        }
    }

    private void deleteIfSafe(Node startNode, NamespaceTable namespaceTable, GId serverId, ManagedObjectRepresentation toRemoveMo) {
        Node toRemoveNode = (Node)toRemoveMo.get("c8y_ua_Node");
        super.updateAddressSpaceForDeletedNode(startNode, toRemoveNode, nodeIdToFind -> {
            Optional nodeMoMaybe = this.addressSpaceRepository.findNodeMo(namespaceTable, serverId.getValue(), nodeIdToFind);
            if (nodeMoMaybe.isPresent()) {
                Node node = (Node)((ManagedObjectRepresentation)nodeMoMaybe.get()).get("c8y_ua_Node");
                return Optional.of(node);
            }
            return Optional.empty();
        }, nodeToUpdate -> {
            ManagedObjectRepresentation update = new ManagedObjectRepresentation();
            update.setId(toRemoveMo.getId());
            update.set(nodeToUpdate, "c8y_ua_Node");
            this.inventoryRepository.update(update);
        }, nodeIdToDelete -> {
            GId toRemoveId = toRemoveMo.getId();
            log.info("Deleting node that no longer exists in server: " + toRemoveNode.getNodeId() + " GId: " + toRemoveId.getValue());
            this.inventoryRepository.delete(toRemoveId, true);
        });
    }

    private void removeParentChildRefIfStartNodeParentChanged(ManagedObjectRepresentation existingStartNodeMo, NamespaceTable namespaceTable, GId serverId, Node startNode) {
        if (Objects.isNull(existingStartNodeMo)) {
            return;
        }
        Node existingStartNode = (Node)existingStartNodeMo.get("c8y_ua_Node");
        Set scannedStartNodeAncestorPaths = startNode.getAncestorNodeIds();
        Set existingStartNodeAncestorPaths = existingStartNode.getAncestorNodeIds();
        HashMap checkedParents = new HashMap();
        super.removeParentChildRefIfStartNodeParentChanged(startNode, existingStartNodeAncestorPaths, scannedStartNodeAncestorPaths, nodeIdToSearch -> {
            Optional nodeMo = this.addressSpaceRepository.findNodeMo(namespaceTable, serverId.getValue(), nodeIdToSearch);
            if (nodeMo.isPresent()) {
                Node node = (Node)((ManagedObjectRepresentation)nodeMo.get()).get("c8y_ua_Node");
                checkedParents.put(node.getNodeId(), (ManagedObjectRepresentation)nodeMo.get());
                return Optional.of(node);
            }
            return Optional.empty();
        }, nodeToUpdate -> {
            ManagedObjectRepresentation update = new ManagedObjectRepresentation();
            update.setId(((ManagedObjectRepresentation)checkedParents.get(nodeToUpdate.getNodeId())).getId());
            update.set(nodeToUpdate, "c8y_ua_Node");
            this.inventoryRepository.update(update);
        });
    }

    private void cancelSyncJobs(Collection<Future<?>> syncJobs) {
        syncJobs.stream().filter(job -> !job.isDone() && !job.isCancelled()).forEach(job -> job.cancel(true));
    }

    private Map<String, ManagedObjectRepresentation> findExistingAddressSpaceObjects(GId serverMoId, NamespaceTable namespaceTable, Node startNode) {
        log.info("Searching for existing address space managed objects from start node: {}", (Object)startNode.getNodeId());
        ConcurrentHashMap<String, ManagedObjectRepresentation> map = new ConcurrentHashMap<String, ManagedObjectRepresentation>();
        try {
            AddressSpaceUnorderedSubTreeInvFilter filter = new AddressSpaceUnorderedSubTreeInvFilter(serverMoId.getValue(), namespaceTable, startNode);
            PagedManagedObjectCollectionRepresentation collection = (PagedManagedObjectCollectionRepresentation)this.inventoryRepository.getManagedObjects().get(1000, new QueryParam[]{filter});
            for (ManagedObjectRepresentation mo : collection.allPages()) {
                Node node = (Node)mo.get("c8y_ua_Node");
                if (node == null) continue;
                map.put(node.getNodeId(), mo);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Cannot encode inventory filter to get subtree of address space", (Throwable)e);
        }
        log.info("Existing address space objects size: " + map.size());
        return map;
    }

    private void trySyncNode(Node node, GId serverMoId, Map<String, ManagedObjectRepresentation> existing, Map<String, GId> synced) {
        try {
            this.syncNode(node, serverMoId, existing, synced);
        }
        catch (Exception e) {
            log.error("Error synchronizing address space to Platform", (Throwable)e);
            throw e;
        }
    }

    private void syncNode(Node node, GId serverMoId, Map<String, ManagedObjectRepresentation> existing, Map<String, GId> synced) {
        if (existing.containsKey(node.getNodeId())) {
            GId nodeMoId = existing.get(node.getNodeId()).getId();
            this.updateNodeMo(nodeMoId, node, serverMoId);
            synced.put(node.getNodeId(), nodeMoId);
        } else {
            ManagedObjectRepresentation nodeMo = this.createNodeMo(node, serverMoId);
            synced.put(node.getNodeId(), nodeMo.getId());
        }
    }

    public ManagedObjectRepresentation createOrUpdateNode(Node node, NamespaceTable namespaceTable, GId serverId) {
        Optional nodeMo = this.addressSpaceRepository.findNodeMo(namespaceTable, serverId.getValue(), node.getNodeId());
        if (nodeMo.isPresent()) {
            return this.updateNodeMo(((ManagedObjectRepresentation)nodeMo.get()).getId(), node, serverId);
        }
        return this.createNodeMo(node, serverId);
    }

    public void updateNode(Node node, NamespaceTable namespaceTable, GId serverId) {
        Optional nodeMo = this.addressSpaceRepository.findNodeMo(namespaceTable, serverId.getValue(), node.getNodeId());
        if (nodeMo.isPresent()) {
            this.updateNodeMo(((ManagedObjectRepresentation)nodeMo.get()).getId(), node, serverId);
        }
    }

    public void deleteNode(String nodeId, NamespaceTable namespaceTable, GId serverId) {
        Optional nodeMo = this.addressSpaceRepository.findNodeMo(namespaceTable, serverId.getValue(), nodeId);
        if (nodeMo.isPresent()) {
            this.deleteNodeMo(((ManagedObjectRepresentation)nodeMo.get()).getId());
        }
    }

    private ManagedObjectRepresentation updateNodeMo(GId nodeMoId, Node node, GId serverMoId) {
        ManagedObjectRepresentation update = new ManagedObjectRepresentation();
        update.setId(nodeMoId);
        update.set((Object)node, "c8y_ua_Node");
        this.populateRootLevelFragments(node, serverMoId, update);
        return this.inventoryRepository.update(update, 2);
    }

    private ManagedObjectRepresentation createNodeMo(Node node, GId serverMoId) {
        ManagedObjectRepresentation nodeMo = new ManagedObjectRepresentation();
        nodeMo.setName(node.getDisplayName());
        nodeMo.setType("c8y_OpcuaNode");
        nodeMo.set((Object)node, "c8y_ua_Node");
        this.populateRootLevelFragments(node, serverMoId, nodeMo);
        ID identity = IdentityUtils.buildAddressSpaceNodeExternalId((String)serverMoId.getValue(), (String)node.getNodeId());
        nodeMo = this.inventoryRepository.create(nodeMo, 2);
        this.identityRepository.create(identity, nodeMo.getId(), 2);
        return nodeMo;
    }

    private void deleteNodeMo(GId nodeMoId) {
        this.inventoryRepository.delete(nodeMoId);
    }

    private void populateRootLevelFragments(Node node, GId serverMoId, ManagedObjectRepresentation update) {
        update.set((Object)serverMoId, "c8y_OpcuaServerId");
        List absolutePaths = node.getAbsolutePaths().stream().map(absPath -> String.join((CharSequence)"/", absPath)).collect(Collectors.toList());
        update.set((Object)String.join((CharSequence)";", absolutePaths), "c8y_ua_AbsolutePaths");
        List ancestorNodeIds = node.getAncestorNodeIds().stream().map(ancestorNodeId -> String.join((CharSequence)"/", ancestorNodeId)).collect(Collectors.toList());
        update.set((Object)String.join((CharSequence)";", ancestorNodeIds), "c8y_ua_AncestorNodeIds");
        update.set((Object)node.getDisplayName(), "c8y_ua_DisplayName");
        update.set((Object)node.getBrowseName(), "c8y_ua_BrowseName");
        update.set((Object)node.getNodeId(), "c8y_ua_NodeId");
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }
}

