/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.valuemap;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.bootstrap.model.BootstrapReadyEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerDisconnectedEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueAbnormalStatusCodeEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.opcua.client.gateway.subscription.model.DataChangedEvent;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.opcua.common.valuemap.PlatformOpcuaValue;
import com.cumulocity.opcua.common.valuemap.ServerValueMap;
import com.cumulocity.opcua.common.valuemap.ValueMapRepository;
import com.cumulocity.sdk.client.identity.IdentityApi;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.Variant;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ValueMapManagerService {
    private static final Logger log = LoggerFactory.getLogger(ValueMapManagerService.class);
    @Autowired
    private IdentityApi identityApi;
    @Autowired
    private InventoryRepository inventoryRepository;
    @Autowired
    private ValueMapRepository valueMapRepository;
    @Autowired
    private PlatformProvider platformProvider;
    @Autowired
    private GatewayManager gatewayManager;
    private ConcurrentHashMap<String, ServerValueMap> valueMaps = new ConcurrentHashMap();
    private Set<String> stopSet = ConcurrentHashMap.newKeySet();
    @Value(value="${gateway.valueMap.lifeTime:30}")
    private Long valueMapLifetimeInSeconds = 30L;

    @EventListener
    public void checkIfServerWasDisconnectedBecauseOfDeletion(ServerDisconnectedEvent serverDisconnectedEvent) {
        try {
            ServerIdentifier serverIdentifier = serverDisconnectedEvent.getServerIdentifier();
            GId serverId = serverIdentifier.getInventoryIdentifier();
            if (this.inventoryRepository.isMissing(serverId)) {
                log.info("Deletion of server {} detected", (Object)serverId);
                this.removeValueMapForServer(serverId);
            } else {
                log.info("Server {} was disconnected, but managed object not deleted. Keeping Value Map", (Object)serverId);
            }
        }
        catch (Exception e) {
            log.error("Unexpected Error when managing value map: {}", (Throwable)e);
        }
    }

    public void removeValueMapForServer(GId serverId) {
        log.info("Preventing Value map upgrades for deleted server {}", (Object)serverId);
        this.valueMapRepository.deleteServerValueMapForServer(serverId.getValue());
        this.stopSet.add(serverId.getValue());
        this.valueMaps.remove(serverId.getValue());
    }

    @EventListener(classes={ValueReadSuccessfulEvent.class, DataChangedEvent.class, ValueAbnormalStatusCodeEvent.class})
    public void onBaseDataValueEventReceived(BaseDataValueEvent event) {
        String serverId = event.getServerId();
        String value = this.getValueStringOrNull(event);
        Long lastUpdated = this.getLastUpdatedOrNull(event);
        if (this.stopSet.contains(serverId)) {
            log.info("Ignoring value from removed server {}", (Object)serverId);
            return;
        }
        PlatformOpcuaValue opcuaValue = new PlatformOpcuaValue(lastUpdated, value);
        ServerValueMap valueMap = this.getServerValueMapFromMemory(serverId);
        log.trace("VM {}, Put {}-> {}", new Object[]{serverId, event.getNodeId(), opcuaValue});
        valueMap.put((Object)event.getNodeId(), (Object)opcuaValue);
    }

    @Scheduled(fixedRateString="${gateway.valueMap.lifeTime:30}000")
    public void syncAllValueMaps() {
        if (this.valueMaps.isEmpty()) {
            log.info("No values are currently known. Skipping persisting value maps");
        } else {
            log.info("Storing value maps for all servers for which values have been seen {}", (Object)((ConcurrentHashMap.CollectionView)((Object)this.valueMaps.keySet())).toString());
            ((ConcurrentHashMap.KeySetView)this.valueMaps.keySet()).forEach(serverKey -> this.updateValueMapForServerInPlatform(serverKey));
        }
        this.stopSet.clear();
    }

    @EventListener
    @Order(value=3)
    public void cleanOrphanedValueMapsAtStartup(BootstrapReadyEvent bootstrapReadyEvent) {
        try {
            this.clearAwayOrphanedValueMaps();
        }
        catch (Exception e) {
            log.error("Unexpected Error while cleaning away orphaned value maps: {}", (Throwable)e);
        }
    }

    @Scheduled(fixedRateString="${gateway.valueMap.orphanDetectionInterval:3600}000")
    public void clearAwayOrphanedValueMaps() {
        if (!this.platformProvider.isCredentialsAvailable()) {
            log.info("No credentials are available yet: Cannot clean away orphaned server value maps.");
            return;
        }
        log.info("Cleaning away orphaned server value maps");
        this.valueMapRepository.cleanAwayOrphanedServerValueMaps(this.gatewayManager.getGatewayDetails().getGatewayDevice().getOwner());
    }

    private void updateValueMapForServerInPlatform(String serverId) {
        ServerValueMap serverValueMap = this.getServerValueMapFromMemory(serverId);
        if (serverValueMap.isEmpty()) {
            log.debug("Server value map for server {} is empty, skipping persisting.", (Object)serverId);
            return;
        }
        if (this.stopSet.contains(serverId)) {
            log.info("Skipping value map update for recently removed server {}", (Object)serverId);
            return;
        }
        log.debug("Storing value map for server {}", (Object)serverId);
        this.valueMapRepository.updateValueMap(serverId, serverValueMap);
        this.emptyServerValueMap(serverId);
    }

    public ServerValueMap getServerValueMapFromMemory(String serverId) {
        ServerValueMap serverValueMap = (ServerValueMap)this.valueMaps.get(serverId);
        if (serverValueMap == null) {
            log.info("Initializing new value map for server Id {}", (Object)serverId);
            serverValueMap = this.emptyServerValueMap(serverId);
        }
        return serverValueMap;
    }

    @NotNull
    private ServerValueMap emptyServerValueMap(String serverId) {
        ServerValueMap serverValueMap = new ServerValueMap();
        serverValueMap.setLifeTime(this.valueMapLifetimeInSeconds.longValue());
        this.valueMaps.put(serverId, serverValueMap);
        return serverValueMap;
    }

    @Nullable
    private String getValueStringOrNull(BaseDataValueEvent event) {
        DataValue dval;
        String value = null;
        if (event.getValue() != null && (dval = event.getValue()).getValue() != null) {
            Variant variant = dval.getValue();
            value = variant.toString();
        }
        return value;
    }

    @Nullable
    private Long getLastUpdatedOrNull(BaseDataValueEvent event) {
        return event.getValue().getSourceTimestamp() != null ? Long.valueOf(event.getValue().getSourceTimestamp().getTimeInMillis()) : null;
    }

    public IdentityApi getIdentityApi() {
        return this.identityApi;
    }

    public InventoryRepository getInventoryRepository() {
        return this.inventoryRepository;
    }

    public ValueMapRepository getValueMapRepository() {
        return this.valueMapRepository;
    }

    public PlatformProvider getPlatformProvider() {
        return this.platformProvider;
    }

    public GatewayManager getGatewayManager() {
        return this.gatewayManager;
    }

    public ConcurrentHashMap<String, ServerValueMap> getValueMaps() {
        return this.valueMaps;
    }

    public Set<String> getStopSet() {
        return this.stopSet;
    }

    public Long getValueMapLifetimeInSeconds() {
        return this.valueMapLifetimeInSeconds;
    }

    public void setIdentityApi(IdentityApi identityApi) {
        this.identityApi = identityApi;
    }

    public void setInventoryRepository(InventoryRepository inventoryRepository) {
        this.inventoryRepository = inventoryRepository;
    }

    public void setPlatformProvider(PlatformProvider platformProvider) {
        this.platformProvider = platformProvider;
    }

    public void setGatewayManager(GatewayManager gatewayManager) {
        this.gatewayManager = gatewayManager;
    }

    public void setValueMaps(ConcurrentHashMap<String, ServerValueMap> valueMaps) {
        this.valueMaps = valueMaps;
    }

    public void setStopSet(Set<String> stopSet) {
        this.stopSet = stopSet;
    }

    public void setValueMapLifetimeInSeconds(Long valueMapLifetimeInSeconds) {
        this.valueMapLifetimeInSeconds = valueMapLifetimeInSeconds;
    }

    public void setValueMapRepository(ValueMapRepository valueMapRepository) {
        this.valueMapRepository = valueMapRepository;
    }
}

