/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository.util;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.util.ElementQueueOperation;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkElementsQueueOperation<T extends AbstractExtensibleRepresentation>
implements ElementQueueOperation<T, List<T>> {
    private static final Logger log = LoggerFactory.getLogger(BulkElementsQueueOperation.class);
    public static final int MAX_BULK_SIZE = 1000;
    private BaseQueuedRepository<T, List<T>> baseQueuedRepository;

    public BulkElementsQueueOperation(BaseQueuedRepository<T, List<T>> baseQueuedRepository) {
        this.baseQueuedRepository = baseQueuedRepository;
    }

    public void addToQueue(ConcurrentLinkedQueue<T> queue, List<T> elements) {
        queue.addAll(elements);
    }

    public void addToQueueWithSourceCheck(ConcurrentLinkedQueue<T> queue, List<T> elements) {
        this.addToQueue(queue, elements);
    }

    public void addToQueueWithSourceAvailability(ConcurrentLinkedQueue<T> queue, List<T> elements) {
        List validElements = this.getOnlyWithValidSources(elements);
        this.addToQueueWithSourceCheck(queue, validElements);
    }

    public List<T> getFromQueue(ConcurrentLinkedQueue<T> queue) {
        AbstractExtensibleRepresentation element;
        ArrayList<AbstractExtensibleRepresentation> elementsToCreate = new ArrayList<AbstractExtensibleRepresentation>();
        for (int moreElementsToAdd = 1000; moreElementsToAdd > 0 && Objects.nonNull(element = (AbstractExtensibleRepresentation)queue.poll()); --moreElementsToAdd) {
            elementsToCreate.add(element);
        }
        return elementsToCreate;
    }

    private List<T> getOnlyWithValidSources(List<T> elements) {
        LinkedList<AbstractExtensibleRepresentation> validElements = new LinkedList<AbstractExtensibleRepresentation>();
        int purged = 0;
        for (AbstractExtensibleRepresentation e : elements) {
            GId source = this.baseQueuedRepository.getElementSource(e);
            boolean accessible = this.baseQueuedRepository.getInventoryPresence().checkSourceAvailability(source);
            if (accessible) {
                validElements.add(e);
                continue;
            }
            ++purged;
        }
        log.info("Purged out {} elements due to invalid sources", (Object)purged);
        return validElements;
    }
}

