/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.BaseOperation;
import c8y.ua.command.ReadNodeAttributes;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.core.NodeAttributes;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReadNodeAttributesOperationHandler
extends UAOperationHandler<ReadNodeAttributes> {
    private static final Logger log = LoggerFactory.getLogger(ReadNodeAttributesOperationHandler.class);
    @Autowired
    OpcuaSerializer serializer;

    @Autowired
    public ReadNodeAttributesOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, ReadNodeAttributes.class, deviceControlApi, inventoryApi, nodeValidator);
    }

    protected HandleInternalResult handleInternal(ReadNodeAttributes operation) throws OperationExecutionException {
        String nodeId = operation.getNode();
        Optional clientOptional = this.resolveClient((BaseOperation)operation);
        if (!clientOptional.isPresent()) {
            throw new OperationExecutionException("UA Server is not resolvable / not connected!");
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        try {
            NodeAttributes nodeAttributes = client.readAttributes(nodeId);
            String jsonValue = this.serializer.toJson((Object)nodeAttributes);
            Command cmd = new Command();
            cmd.setResult(jsonValue);
            return new HandleInternalResult(cmd, true, null);
        }
        catch (OpcuaClientException e) {
            throw new OperationExecutionException((Throwable)e);
        }
    }

    protected Set<String> getQueryNodes(ReadNodeAttributes operation) {
        return operation.getNode() != null ? Set.of(operation.getNode()) : Set.of();
    }
}

