/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.monitoring;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.sdk.client.alarm.AlarmFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class QueueMonitoringService {
    private static final Logger log = LoggerFactory.getLogger(QueueMonitoringService.class);
    static final int WINDOW_SIZE = 6;
    @Autowired
    private ApplicationContext ctx;
    private Map<String, ArrayList<Integer>> queueMetrics = new HashMap();
    private Map<String, Integer> queueWindowIndex = new HashMap();
    private Map<String, Boolean> queueAlarmRaised = new HashMap();

    public void report(String queue, Integer size) {
        try {
            if (size != null && queue != null) {
                ArrayList window = this.getWindow(queue);
                if (!this.queueWindowIndex.containsKey(queue)) {
                    log.debug("Queue [{}] does not exist", (Object)queue);
                    return;
                }
                int prevIndex = (Integer)this.queueWindowIndex.get(queue);
                int index = this.nextIndex(prevIndex);
                this.queueWindowIndex.put(queue, index);
                if (Objects.isNull(window)) {
                    log.debug("No window yet");
                    return;
                }
                window.set(index, size);
                this.dumpWindow(queue);
                this.raiseAlarmIfNeeded(queue);
            }
        }
        catch (Exception e) {
            log.error("Exception in QueueMonitoringService", (Throwable)e);
        }
    }

    private ArrayList<Integer> getWindow(String queue) {
        if (!this.queueMetrics.containsKey(queue)) {
            ArrayList<Object> window = new ArrayList<Object>(6);
            for (int i = 0; i < 6; ++i) {
                window.add(null);
            }
            this.queueMetrics.put(queue, window);
            this.queueWindowIndex.put(queue, 0);
            this.queueAlarmRaised.put(queue, false);
        }
        return (ArrayList)this.queueMetrics.get(queue);
    }

    private void raiseAlarmIfNeeded(String queue) {
        AlarmRepository alarmRepository = (AlarmRepository)this.ctx.getBean(AlarmRepository.class);
        GatewayManager gatewayManager = (GatewayManager)this.ctx.getBean(GatewayManager.class);
        if (gatewayManager.getGatewayDetails().isFullyInitialized()) {
            if (this.shouldRaiseAlarm(queue)) {
                log.warn("Raising queue growth alarm for queue: " + queue);
                this.dumpWindow(queue);
                alarmRepository.create(gatewayManager.getGatewayDetails().getGatewayDevice().getId(), "c8y_ua_GatewayQueueGrowth_" + queue, CumulocitySeverities.CRITICAL.name(), queue + " is constantly growing! Possible memory overflow which will result in gateway crash!");
                this.queueAlarmRaised.put(queue, true);
            } else if (this.queueAlarmRaised.containsKey(queue) && ((Boolean)this.queueAlarmRaised.get(queue)).booleanValue()) {
                AlarmFilter filter = new AlarmFilter().bySource(gatewayManager.getGatewayDetails().getGatewayDevice().getId()).byType("c8y_ua_GatewayQueueGrowth_" + queue);
                alarmRepository.clearAlarmsByFilter(filter);
                this.queueAlarmRaised.put(queue, false);
            }
        }
    }

    private boolean shouldRaiseAlarm(String queue) {
        ArrayList window = this.getWindow(queue);
        int currentIndex = (Integer)this.queueWindowIndex.get(queue);
        for (int i = 0; i < 5; ++i) {
            int prevIndex = this.prevIndex(currentIndex);
            if (window.get(currentIndex) == null || window.get(prevIndex) == null) {
                return false;
            }
            if ((Integer)window.get(currentIndex) <= (Integer)window.get(prevIndex)) {
                return false;
            }
            currentIndex = prevIndex;
        }
        return true;
    }

    private void dumpWindow(String queue) {
        ArrayList window = this.getWindow(queue);
        int index = (Integer)this.queueWindowIndex.get(queue);
        for (int i = 0; i < 6; ++i) {
            log.debug("   " + queue + "[" + index + "] = " + String.valueOf(window.get(index)));
            index = this.prevIndex(index);
        }
    }

    private int prevIndex(int index) {
        if (index > 0) {
            return index - 1;
        }
        return 5;
    }

    private int nextIndex(int index) {
        if (++index >= 6) {
            return 0;
        }
        return index;
    }
}

