/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.configuration.MappingsConfiguration;
import com.cumulocity.opcua.client.gateway.configuration.PlatformThinEdgeConfiguration;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BatchValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.HttpPostElement;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.AlarmCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.EventCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.HttpPostElementCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.HttpPostTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.MeasurementCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.ThinEdgeAlarmCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.ThinEdgeBatchCustomActionTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.ThinEdgeBatchEventCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.ThinEdgeBatchMeasurementCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.ThinEdgeCustomActionTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.ThinEdgeEventCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.ThinEdgeMeasurementCreationTask;
import com.cumulocity.opcua.common.model.mapping.ExecutableMappingAction;
import com.cumulocity.opcua.common.model.mapping.action.AlarmCreation;
import com.cumulocity.opcua.common.model.mapping.action.EventCreation;
import com.cumulocity.opcua.common.model.mapping.action.HttpPostAction;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.opcua.common.model.mapping.action.MeasurementCreation;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class MappingExecutionTaskFactory {
    private static final Logger log = LoggerFactory.getLogger(MappingExecutionTaskFactory.class);
    private final ApplicationContext context;
    private final PlatformThinEdgeConfiguration platformThinEdgeConfiguration;
    private final MappingsConfiguration mappingsConfiguration;

    public MappingExecutionTaskFactory(ApplicationContext context, PlatformThinEdgeConfiguration platformThinEdgeConfiguration, MappingsConfiguration mappingsConfiguration) {
        this.context = context;
        this.platformThinEdgeConfiguration = platformThinEdgeConfiguration;
        this.mappingsConfiguration = mappingsConfiguration;
    }

    public Runnable create(ExecutableMappingAction executableMappingAction, BaseDataValueEvent event, GId deviceId, boolean isTaggingEnabled) {
        if (this.platformThinEdgeConfiguration != null && this.platformThinEdgeConfiguration.isUseForDataForwarding()) {
            return this.createForThinEdge(executableMappingAction, event, deviceId, isTaggingEnabled);
        }
        return this.createForStandalone(executableMappingAction, event, deviceId, isTaggingEnabled);
    }

    public Runnable createBatchForMeasurement(Map<String, Collection<MappingAction>> batchActions, BatchValueEvent event, GId deviceId) {
        if (this.platformThinEdgeConfiguration != null && this.platformThinEdgeConfiguration.isUseForDataForwarding()) {
            ThinEdgeBatchMeasurementCreationTask task = (ThinEdgeBatchMeasurementCreationTask)this.context.getBean(ThinEdgeBatchMeasurementCreationTask.class);
            task.setBatchActions(batchActions);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            task.setType(this.mappingsConfiguration.getMergedMeasurementType());
            return task;
        }
        throw new RuntimeException("Merging cyclic reads only supported in thin-edge mode");
    }

    public Runnable createBatchForEvent(Map<String, Collection<MappingAction>> batchActions, BatchValueEvent event, GId deviceId) {
        if (this.platformThinEdgeConfiguration != null && this.platformThinEdgeConfiguration.isUseForDataForwarding()) {
            ThinEdgeBatchEventCreationTask task = (ThinEdgeBatchEventCreationTask)this.context.getBean(ThinEdgeBatchEventCreationTask.class);
            task.setBatchActions(batchActions);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            task.setType(this.mappingsConfiguration.getMergedEventType());
            return task;
        }
        throw new RuntimeException("Merging cyclic reads only supported in thin-edge mode");
    }

    public Runnable createBatchForCustomAction(Map<String, Collection<MappingAction>> batchActions, BatchValueEvent event, GId deviceId) {
        if (this.platformThinEdgeConfiguration != null && this.platformThinEdgeConfiguration.isUseForDataForwarding()) {
            ThinEdgeBatchCustomActionTask task = (ThinEdgeBatchCustomActionTask)this.context.getBean(ThinEdgeBatchCustomActionTask.class);
            task.setBatchActions(batchActions);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            return task;
        }
        throw new RuntimeException("Merging cyclic reads only supported in thin-edge mode");
    }

    private Runnable createForThinEdge(ExecutableMappingAction executableMappingAction, BaseDataValueEvent event, GId deviceId, boolean isTaggingEnabled) {
        MappingAction mappingAction = executableMappingAction.getMappingAction();
        if (mappingAction instanceof AlarmCreation) {
            AlarmCreation alarmMappingAction = ((AlarmCreation)mappingAction).copy();
            ThinEdgeAlarmCreationTask task = (ThinEdgeAlarmCreationTask)this.context.getBean(ThinEdgeAlarmCreationTask.class);
            task.setAlarmCreation(alarmMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            return task;
        }
        if (mappingAction instanceof EventCreation) {
            EventCreation eventMappingAction = ((EventCreation)mappingAction).copy();
            ThinEdgeEventCreationTask task = (ThinEdgeEventCreationTask)this.context.getBean(ThinEdgeEventCreationTask.class);
            task.setEventCreation(eventMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            return task;
        }
        if (mappingAction instanceof MeasurementCreation) {
            MeasurementCreation measurementMappingAction = ((MeasurementCreation)mappingAction).copy();
            ThinEdgeMeasurementCreationTask task = (ThinEdgeMeasurementCreationTask)this.context.getBean(ThinEdgeMeasurementCreationTask.class);
            task.setMeasurementCreation(measurementMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            return task;
        }
        if (mappingAction instanceof HttpPostAction) {
            HttpPostAction httpPostMappingAction = ((HttpPostAction)mappingAction).copy();
            ThinEdgeCustomActionTask task = (ThinEdgeCustomActionTask)this.context.getBean(ThinEdgeCustomActionTask.class);
            task.setCustomAction(httpPostMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            return task;
        }
        throw new RuntimeException("Unknown mappingAction class: " + mappingAction.getClass().getName());
    }

    private Runnable createForStandalone(ExecutableMappingAction executableMappingAction, BaseDataValueEvent event, GId deviceId, boolean isTaggingEnabled) {
        MappingAction mappingAction = executableMappingAction.getMappingAction();
        if (mappingAction instanceof AlarmCreation) {
            AlarmCreationTask task = (AlarmCreationTask)this.context.getBean(AlarmCreationTask.class);
            task.setAlarmCreation((AlarmCreation)mappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            executableMappingAction.getProcessingMode().ifPresent(pm -> task.setProcessingMode(pm));
            return task;
        }
        if (mappingAction instanceof EventCreation) {
            EventCreation eventMappingAction = ((EventCreation)mappingAction).copy();
            if (isTaggingEnabled) {
                eventMappingAction.addHistoricTagWithType();
            }
            EventCreationTask task = (EventCreationTask)this.context.getBean(EventCreationTask.class);
            task.setEventCreation(eventMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            executableMappingAction.getProcessingMode().ifPresent(pm -> task.setProcessingMode(pm));
            return task;
        }
        if (mappingAction instanceof MeasurementCreation) {
            MeasurementCreation measurementMappingAction = ((MeasurementCreation)mappingAction).copy();
            if (isTaggingEnabled) {
                measurementMappingAction.addHistoricTagWithType();
                measurementMappingAction.setFragmentName(measurementMappingAction.getFragmentName(event.getNodeId()) + "_Historic");
            }
            MeasurementCreationTask task = (MeasurementCreationTask)this.context.getBean(MeasurementCreationTask.class);
            task.setMeasurementCreation(measurementMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            executableMappingAction.getProcessingMode().ifPresent(pm -> task.setProcessingMode(pm));
            return task;
        }
        if (mappingAction instanceof HttpPostAction) {
            HttpPostAction httpPostMappingAction = ((HttpPostAction)mappingAction).copy();
            if (isTaggingEnabled) {
                httpPostMappingAction.addHistoricTagWithType();
            }
            HttpPostElementCreationTask task = (HttpPostElementCreationTask)this.context.getBean(HttpPostElementCreationTask.class);
            task.setPostAction(httpPostMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            return task;
        }
        throw new RuntimeException("Unknown mappingAction class: " + mappingAction.getClass().getName());
    }

    public Runnable createHttpPostTask(HttpPostElement httpPost) {
        HttpPostTask task = (HttpPostTask)this.context.getBean(HttpPostTask.class);
        task.httpPostElement = httpPost;
        task.setDeviceId(new GId(httpPost.getServerId()));
        return task;
    }

    public Runnable createHistoric(ExecutableMappingAction executableMappingAction, boolean isTaggingEnabled, BaseDataValueEvent event, GId deviceId) {
        if (isTaggingEnabled) {
            return this.create(executableMappingAction, event, deviceId, true);
        }
        return this.create(executableMappingAction, event, deviceId, false);
    }
}

