/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappings;

import c8y.ua.Node;
import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.DeviceTypeMatchingDiagnostic;
import c8y.ua.data.MappedTargetNode;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.BaseDeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.BrowsePathsMatcher;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.NodeMatcher;
import com.cumulocity.opcua.common.model.mapping.ApplyConstraints;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RegularDeviceTypeMatchingService
extends BaseDeviceTypeMatchingService
implements DeviceTypeMatchingService {
    private static final Logger log = LoggerFactory.getLogger(RegularDeviceTypeMatchingService.class);

    public Collection<DeviceTypeMappedNode> matches(String serverId, List<DeviceType> deviceTypes, boolean includeInactiveDeviceProtocols) throws ServerNotConnectedException, OpcuaClientException {
        log.info("Finding matching nodes in server: " + serverId);
        OpcuaClient client = this.connectionManager.getClient(serverId);
        List workingDeviceTypes = this.applyServerSpecificConstraints(serverId, deviceTypes, includeInactiveDeviceProtocols, client);
        if (CollectionUtils.isEmpty((Collection)workingDeviceTypes)) {
            return Collections.emptySet();
        }
        return this.findMatchingNodesForServer(serverId, workingDeviceTypes, client);
    }

    public DeviceTypeMatchingDiagnostic testMatching(String serverId, DeviceType deviceType, String rootNodeId) throws OpcuaClientException, ServerNotConnectedException {
        NamespaceTable namespaceTable;
        OpcuaClient client;
        try {
            client = this.connectionManager.getClient(serverId);
        }
        catch (ServerNotConnectedException e) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)"Server not connected");
        }
        DeviceTypeMatchingDiagnostic diagnostic = this.diagnoseServerSpecificConstraints(serverId, deviceType, client);
        if (Objects.nonNull(diagnostic) && !diagnostic.isMatches()) {
            return diagnostic;
        }
        List addressSpace = this.retrieveAddressSpace(serverId, client);
        AtomicReference rootNodeRef = new AtomicReference();
        Map allPossibleBrowsePaths = this.addressSpaceToAbsolutePathMap(client.getNamespaceTable(), addressSpace, rootNodeId, rootNodeRef);
        if (Objects.isNull(rootNodeRef.get())) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Node %s is not found in address space", rootNodeId));
        }
        Node rootNode = (Node)rootNodeRef.get();
        diagnostic = this.diagnoseMatchesNodeIdsConstraints(deviceType, rootNodeId, rootNode, namespaceTable = client.getNamespaceTable());
        if (Objects.nonNull(diagnostic) && !diagnostic.isMatches()) {
            return diagnostic;
        }
        ArrayList targetNodes = new ArrayList();
        BrowsePathsMatcher.BrowsePathMatchingResult browsePathMatchingResult = BrowsePathsMatcher.matchBrowsePaths((Collection)deviceType.getMappings(), (Node)rootNode, (Map)allPossibleBrowsePaths, (NamespaceTable)client.getNamespaceTable(), (boolean)false);
        if (browsePathMatchingResult.hasNonMatch()) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Browse paths do not match: %s", browsePathMatchingResult.nonMatchBrowsePaths));
        }
        ArrayList mappedTargetNodes = null;
        if (browsePathMatchingResult.hasMatchedTargetNodes()) {
            targetNodes.addAll(browsePathMatchingResult.matchedTargetNodes);
            mappedTargetNodes = new ArrayList(targetNodes);
        }
        if ((browsePathMatchingResult = BrowsePathsMatcher.matchBrowsePaths((Collection)deviceType.getUaEventMappings(), (Node)rootNode, (Map)allPossibleBrowsePaths, (NamespaceTable)client.getNamespaceTable(), (boolean)false)).hasNonMatch()) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Browse paths of ua event mappings do not match: %s", browsePathMatchingResult.nonMatchBrowsePaths));
        }
        if (browsePathMatchingResult.hasMatchedTargetNodes()) {
            targetNodes.addAll(browsePathMatchingResult.matchedTargetNodes);
        }
        if (this.hasCyclicRead(deviceType) && !CollectionUtils.isEmpty(mappedTargetNodes)) {
            for (MappedTargetNode targetNode : mappedTargetNodes) {
                if (!NodeMatcher.nonSupportsValueAttribute((OpcuaClient)client, (String)targetNode.getTargetNodeId())) continue;
                return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Target node: %s does not support Value attribute", targetNode.getTargetNodeId()));
            }
        }
        return new DeviceTypeMatchingDiagnostic(true);
    }

    private Collection<DeviceTypeMappedNode> findMatchingNodesForServer(String serverId, List<DeviceType> deviceTypes, OpcuaClient client) throws OpcuaClientException {
        List addressSpace = this.retrieveAddressSpace(serverId, client);
        return this.findMatchingNodesInAddressSpace(addressSpace, deviceTypes, client);
    }

    private Collection<DeviceTypeMappedNode> findMatchingNodesInAddressSpace(List<Node> addressSpace, List<DeviceType> deviceTypes, OpcuaClient client) {
        long start = System.currentTimeMillis();
        HashSet<DeviceTypeMappedNode> result = new HashSet<DeviceTypeMappedNode>();
        log.info("Creating paths set, address space size: {}", (Object)addressSpace.size());
        Map browsePaths = this.addressSpaceToAbsolutePathMap(client.getNamespaceTable(), addressSpace, null, null);
        log.info("Testing nodes one by one... ");
        for (Node node : addressSpace) {
            for (DeviceType deviceType : deviceTypes) {
                Collection targetNodes = this.findMatchingTargetNodes(client, deviceType, node, browsePaths);
                if (CollectionUtils.isEmpty((Collection)targetNodes)) continue;
                this.addResult(deviceType, node, targetNodes, result);
            }
        }
        long end = System.currentTimeMillis();
        log.info("findMatchingAddressSpace - Done, found {} matching node(s), took {} milliseconds", (Object)result.size(), (Object)(end - start));
        return result;
    }

    private Map<List<String>, String> addressSpaceToAbsolutePathMap(NamespaceTable namespaceTable, List<Node> addressSpace, String knownNodeId, AtomicReference<Node> nodeReference) {
        HashMap<List<String>, String> result = new HashMap<List<String>, String>();
        if (!StringUtils.isEmpty((Object)knownNodeId)) {
            for (Node node : addressSpace) {
                if (NodeIds.nodeIdEquals((NamespaceTable)namespaceTable, (String)knownNodeId, (String)node.getNodeId())) {
                    nodeReference.set(node);
                }
                this.addAbsolutePaths(namespaceTable, result, node);
            }
        } else {
            for (Node node : addressSpace) {
                this.addAbsolutePaths(namespaceTable, result, node);
            }
        }
        return result;
    }

    private void addAbsolutePaths(NamespaceTable namespaceTable, Map<List<String>, String> result, Node node) {
        node.setAbsolutePaths(node.getAbsolutePaths().stream().map(absPath -> NodeIds.toBrowsePathWithNsUri((NamespaceTable)namespaceTable, (List)absPath)).collect(Collectors.toSet()));
        for (List absPath2 : node.getAbsolutePaths()) {
            result.put(absPath2, node.getNodeId());
        }
    }

    private void addResult(DeviceType deviceType, Node node, Collection<MappedTargetNode> mappedTargetNodes, Collection<DeviceTypeMappedNode> result) {
        DeviceTypeMappedNode mappedNode = new DeviceTypeMappedNode(node.getNodeId(), deviceType.getId(), mappedTargetNodes);
        result.add(mappedNode);
    }

    Collection<MappedTargetNode> findMatchingTargetNodes(OpcuaClient client, DeviceType deviceType, Node node, Map<List<String>, String> browsePathNodesMap) {
        boolean nodeValueNotSupported;
        BrowsePathsMatcher.BrowsePathMatchingResult browsePathMatchingResult;
        HashSet<MappedTargetNode> result = new HashSet<MappedTargetNode>();
        NamespaceTable namespaceTable = client.getNamespaceTable();
        ApplyConstraints applyConstraints = deviceType.getApplyConstraints();
        if (applyConstraints != null) {
            if (NodeMatcher.nonMatchNodeIdsConstraint((String)node.getNodeId(), (NamespaceTable)namespaceTable, (Collection)applyConstraints.getMatchesNodeIds())) {
                return Collections.emptySet();
            }
            if (BrowsePathsMatcher.nonMatchBrowsePathRegex((Node)node, (String)applyConstraints.getBrowsePathMatchesRegex())) {
                return Collections.emptySet();
            }
        }
        if ((browsePathMatchingResult = BrowsePathsMatcher.matchBrowsePaths((Collection)deviceType.getMappings(), (Node)node, browsePathNodesMap, (NamespaceTable)client.getNamespaceTable(), (boolean)true)).hasNonMatch()) {
            return Collections.emptySet();
        }
        ArrayList mappingTargetNodes = null;
        if (browsePathMatchingResult.hasMatchedTargetNodes()) {
            result.addAll(browsePathMatchingResult.matchedTargetNodes);
            mappingTargetNodes = new ArrayList(result);
        }
        if ((browsePathMatchingResult = BrowsePathsMatcher.matchBrowsePaths((Collection)deviceType.getUaEventMappings(), (Node)node, browsePathNodesMap, (NamespaceTable)client.getNamespaceTable(), (boolean)true)).hasNonMatch()) {
            return Collections.emptySet();
        }
        if (browsePathMatchingResult.hasMatchedTargetNodes()) {
            result.addAll(browsePathMatchingResult.matchedTargetNodes);
        }
        if (this.hasCyclicRead(deviceType) && !CollectionUtils.isEmpty(mappingTargetNodes) && (nodeValueNotSupported = mappingTargetNodes.stream().anyMatch(targetNode -> NodeMatcher.nonSupportsValueAttribute((OpcuaClient)client, (String)targetNode.getTargetNodeId())))) {
            log.warn("One or more mappings targeting to a node which does not support Value attribute. Target nodes: {}", mappingTargetNodes);
            return Collections.emptySet();
        }
        if (!CollectionUtils.isEmpty(result)) {
            log.info("Device type: " + deviceType.getId() + " matches " + node.getNodeId());
        }
        return result;
    }
}

