/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.jmx;

import c8y.ua.ClientConfig;
import com.cumulocity.model.JSONBase;
import com.cumulocity.opcua.client.gateway.cyclicreader.CyclicReadExecutor;
import com.cumulocity.opcua.client.gateway.jmx.HeapSpaceInfo;
import com.cumulocity.opcua.client.gateway.jmx.ThreadCountProvider;
import com.cumulocity.opcua.client.gateway.mappingsexecution.MappingsExecutor;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.EventRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.MeasurementRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.QueuedRepository;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@ManagedResource
@Component
public class ServerMonitoringMBean {
    private static final Logger log = LoggerFactory.getLogger(ServerMonitoringMBean.class);
    private Map<String, ClientConfig> serversConfigMap = new ConcurrentHashMap();
    private Map<String, Boolean> connectionStatusMap = new ConcurrentHashMap();
    private Map<String, Integer> failedConnectionAttemptsMap = new ConcurrentHashMap();
    private Map<String, Date> serverSubscriptionUpdateTimeMap = new ConcurrentHashMap();
    private Boolean gatewayStarted = false;
    @Autowired
    private ThreadCountProvider threadCountProvider;
    @Autowired
    List<QueuedRepository<?>> repositories;
    @Autowired
    private ApplicationContext ctx;

    @ManagedAttribute
    public Map<String, Boolean> getConnectionStatusMap() {
        return this.connectionStatusMap;
    }

    @ManagedOperation
    public Boolean isServerConnected(String serverName) {
        return this.connectionStatusMap.getOrDefault(serverName, false);
    }

    @ManagedOperation
    public Boolean isServerConfigured(String serverName) {
        return this.serversConfigMap.containsKey(serverName);
    }

    @ManagedAttribute
    public Boolean getGatewayStarted() {
        return this.gatewayStarted;
    }

    @ManagedOperation
    public Integer getFailedConnectionAttemptsSinceLastSuccess(String serverName) {
        return (Integer)this.failedConnectionAttemptsMap.get(serverName);
    }

    @ManagedOperation
    public void performGC() {
        System.gc();
    }

    @ManagedOperation
    public Date getLastUpdateSubscriptionTime(String serverId) {
        return (Date)this.serverSubscriptionUpdateTimeMap.get(serverId);
    }

    @ManagedAttribute
    public String getRepositoriesStatistics() {
        StringBuilder sb = new StringBuilder();
        for (QueuedRepository repository : this.repositories) {
            sb.append(repository.getClass().getName()).append(": ").append(repository.getQueueSize()).append("\n");
        }
        return sb.toString();
    }

    @ManagedAttribute
    public Integer getAlarmRepositoryQueueSize() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof AlarmRepository)) continue;
            return repository.getQueueSize();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getAlarmRepositoryActiveThreads() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof AlarmRepository)) continue;
            return repository.getActiveThreads();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getAlarmRepositoryQueuedThreads() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof AlarmRepository)) continue;
            return repository.getQueuedThreads();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getMeasurementRepositoryQueueSize() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof MeasurementRepository)) continue;
            return repository.getQueueSize();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getMeasurementRepositoryActiveThreads() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof MeasurementRepository)) continue;
            return repository.getActiveThreads();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getMeasurementRepositoryQueuedThreads() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof MeasurementRepository)) continue;
            return repository.getQueuedThreads();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getEventRepositoryQueueSize() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof EventRepository)) continue;
            return repository.getQueueSize();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getEventRepositoryActiveThreads() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof EventRepository)) continue;
            return repository.getActiveThreads();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getEventRepositoryQueuedThreads() {
        for (QueuedRepository repository : this.repositories) {
            if (!(repository instanceof EventRepository)) continue;
            return repository.getQueuedThreads();
        }
        return null;
    }

    @ManagedAttribute
    public Integer getCyclicReadActiveThreads() {
        return ((CyclicReadExecutor)this.ctx.getBean(CyclicReadExecutor.class)).getActiveThreads();
    }

    @ManagedAttribute
    public Integer getMappingExecutorActiveThreads() {
        return ((MappingsExecutor)this.ctx.getBean(MappingsExecutor.class)).getActiveThreads();
    }

    @ManagedAttribute
    public Integer getMappingExecutorQueuedThreads() {
        return ((MappingsExecutor)this.ctx.getBean(MappingsExecutor.class)).getQueuedThreads();
    }

    @ManagedAttribute
    public String getThreadPoolsCount() {
        return JSONBase.getJSONGenerator().forValue((Object)this.threadCountProvider.getThreadCount());
    }

    @ManagedAttribute
    public String getHeapSpaceInfo() {
        return JSONBase.getJSONGenerator().forValue((Object)HeapSpaceInfo.get());
    }

    public void setGatewayStarted(Boolean gatewayStarted) {
        this.gatewayStarted = gatewayStarted;
    }

    public void addServer(String serverName, ClientConfig config) {
        log.debug("server added: " + serverName);
        this.serversConfigMap.put(serverName, config);
        this.connectionStatusMap.put(serverName, false);
    }

    public void removeServer(String serverName) {
        log.debug("server removed: " + serverName);
        this.serversConfigMap.remove(serverName);
        this.markServerDisconnected(serverName);
    }

    public void markServerConnected(String serverName) {
        log.debug("Marking server {} as connected", (Object)serverName);
        this.connectionStatusMap.put(serverName, true);
        this.failedConnectionAttemptsMap.put(serverName, 0);
    }

    public void markServerDisconnected(String serverName) {
        this.connectionStatusMap.put(serverName, false);
    }

    public synchronized void increaseFailedConnectionAttemptsForServer(String serverName) {
        log.info("Increasing failed connection attempts for server {}", (Object)serverName);
        Integer increased = this.failedConnectionAttemptsMap.getOrDefault(serverName, 0) + 1;
        log.info("failed attempts = {}", (Object)increased);
        this.failedConnectionAttemptsMap.put(serverName, increased);
    }

    public void serverSubscriptionUpdateCompleted(String serverId) {
        this.serverSubscriptionUpdateTimeMap.put(serverId, new Date());
    }
}

