/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.encryption;

import c8y.ua.IdentityConfig;
import com.cumulocity.opcua.client.CumulocityApplicationIdentity;
import com.cumulocity.opcua.client.OpcuaClientImpl;
import com.cumulocity.opcua.client.Tools;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.encryption.EncryptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Qualifier
@Scope(value="prototype")
@Primary
public class EncryptedOpcuaClientImpl
extends OpcuaClientImpl {
    private static final Logger log = LoggerFactory.getLogger(EncryptedOpcuaClientImpl.class);
    @Autowired
    private EncryptionService encryptionService;

    public CumulocityApplicationIdentity buildApplicationIdentity(IdentityConfig identityConfig) throws OpcuaClientException {
        try {
            byte[] test = EncryptionService.decryptAESGCM((String)this.encryptionService.fetchSecret(), (String)this.encryptionService.fetchSalt(), (String)this.encryptionService.fetchIv(), (String)identityConfig.getPk());
            return Tools.createApplicationIdentity((byte[])identityConfig.getCertificate(), (byte[])test, (String)identityConfig.getPassword());
        }
        catch (Exception ex) {
            log.error("Exception while decrypting private key");
            throw new OpcuaClientException(ex.getMessage());
        }
    }
}

