/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.datastore.kryo;

import com.cumulocity.opcua.client.gateway.datastore.kryo.KryoClassRegistrar;
import com.cumulocity.opcua.client.gateway.datastore.kryo.KryoFactoryImpl;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoContext {
    private static final Logger log = LoggerFactory.getLogger(KryoContext.class);
    private static final int DEFAULT_BUFFER_SIZE = 102400;
    private KryoPool pool;

    public KryoContext(KryoClassRegistrar registrar) {
        KryoFactoryImpl factory = new KryoFactoryImpl(registrar);
        this.pool = new KryoPool.Builder((KryoFactory)factory).softReferences().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeToFile(File file, Object object) throws FileNotFoundException {
        Output output = null;
        Kryo kryo = null;
        try {
            output = new Output((OutputStream)new FileOutputStream(file), 102400);
            kryo = this.pool.borrow();
            log.debug("Serializing object to binary...");
            kryo.writeObject(output, object);
        }
        catch (Throwable throwable) {
            if (Objects.nonNull(output)) {
                output.close();
            }
            if (Objects.nonNull(kryo)) {
                this.pool.release(kryo);
            }
            throw throwable;
        }
        if (Objects.nonNull(output)) {
            output.close();
        }
        if (Objects.nonNull(kryo)) {
            this.pool.release(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserializeFromFile(File file, Class classType) throws FileNotFoundException {
        Input input = null;
        Kryo kryo = null;
        try {
            Object object;
            input = new Input((InputStream)new FileInputStream(file));
            kryo = this.pool.borrow();
            log.debug("De-serializing object from binary...");
            Object object2 = object = kryo.readObject(input, classType);
            return object2;
        }
        finally {
            if (Objects.nonNull(input)) {
                input.close();
            }
            if (Objects.nonNull(kryo)) {
                this.pool.release(kryo);
            }
        }
    }
}

