/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription;

import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.DeviceTypeMappedNodeCollection;
import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.jmx.ServerMonitoringMBean;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeRepository;
import com.cumulocity.opcua.client.gateway.mappings.ServerMappingsRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.subscription.SubscriptionDataResolver;
import com.cumulocity.opcua.client.gateway.subscription.SubscriptionService;
import com.cumulocity.opcua.client.gateway.subscription.model.BaseSubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.DeviceTypeFetchedItems;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedNode;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionEventData;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Scope(value="prototype")
class UpdateServerSubscriptionTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UpdateServerSubscriptionTask.class);
    private String serverId;
    private DeviceTypeFetchedItems deviceTypeFetchedItems;
    @Autowired
    private ServerMappingsRepository serverMappingsRepository;
    @Autowired
    @Qualifier(value="compositeSubscriptionService")
    private SubscriptionService subscriptionService;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private SubscriptionDataResolver subscriptionDataResolver;
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private AlarmRepository alarmRepository;
    @Autowired
    private DeviceTypeRepository deviceTypeRepository;
    @Autowired
    private ServerMonitoringMBean serverMonitoringMBean;
    private boolean forceReapply = false;

    UpdateServerSubscriptionTask() {
    }

    @Override
    public void run() {
        log.info("Start checking for subscription update on server: {}", (Object)this.serverId);
        try {
            Map fetchedDeviceTypes = this.deviceTypeFetchedItems.getDeviceTypes();
            boolean updateMapping = false;
            if (this.deviceTypeFetchedItems.isAllDeviceTypes()) {
                DeviceTypeMappedNodeCollection mappedNodeCollection = this.serverMappingsRepository.getServerMappedNodes(this.serverId);
                updateMapping = Objects.isNull(mappedNodeCollection) || Objects.isNull(mappedNodeCollection.getLastUpdated());
                updateMapping = updateMapping || fetchedDeviceTypes.values().stream().anyMatch(deviceType -> Objects.isNull(deviceType.getLastUpdated()) || deviceType.getLastUpdated().isAfter((ReadableInstant)mappedNodeCollection.getLastUpdated()));
                updateMapping = updateMapping || this.deviceTypeFetchedItems.isDeletionDetected();
            } else if (!fetchedDeviceTypes.isEmpty()) {
                updateMapping = true;
            }
            if (updateMapping) {
                DateTime lastUpdatedDateTime = DateTime.now();
                try {
                    this.serverMappingsRepository.updateServerMapping(this.serverId, this.deviceTypeFetchedItems, lastUpdatedDateTime);
                }
                catch (OpcuaClientException | ServerNotConnectedException e) {
                    log.error("Unable to update server mapping: {}", (Object)this.serverId, (Object)e);
                }
            }
            try {
                if (this.forceReapply) {
                    log.info("Forcing to reapply device types to server: {}", (Object)this.serverId);
                    this.reapply();
                } else {
                    this.updateSubscriptionForServer();
                }
            }
            catch (ServerNotConnectedException e) {
                log.error("Unable to update server subscriptions: {}", (Object)this.serverId, (Object)e);
            }
            log.info("Finished checking for subscription update on server: {}", (Object)this.serverId);
            this.serverMonitoringMBean.serverSubscriptionUpdateCompleted(this.serverId);
        }
        catch (Exception e) {
            log.error("Unable to update subscription for server {}", (Object)this.serverId, (Object)e);
            this.createAlarmForFailedSubscriptionUpdate(this.serverId, null, String.format("Error while updating subscription for server %s. Check device gateway logs!", this.serverId));
        }
    }

    private void reapply() throws ServerNotConnectedException {
        this.subscriptionService.removeServerSubscriptions(this.serverId);
        this.updateSubscriptionForServer();
    }

    private void updateSubscriptionForServer() throws ServerNotConnectedException {
        Optional clientOptional = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)this.serverId)));
        if (!clientOptional.isPresent()) {
            log.info("Server: {} is not connected, skip updating subscription!", (Object)this.serverId);
            return;
        }
        DeviceTypeMappedNodeCollection serverMappedNodes = this.serverMappingsRepository.getServerMappedNodes(this.serverId);
        for (SubscribedNode subscribedNode : this.subscriptionRepository.getSubscribedNodes(this.serverId)) {
            if (!Objects.isNull(serverMappedNodes) && serverMappedNodes.contains(subscribedNode.getDeviceTypeId(), rootNodeId -> NodeIds.nodeIdEquals((NamespaceTable)((OpcuaClient)clientOptional.get()).getNamespaceTable(), (String)subscribedNode.getRootNodeId(), (String)rootNodeId))) continue;
            String rootNodeId2 = NodeIds.toNodeId((NamespaceTable)((OpcuaClient)clientOptional.get()).getNamespaceTable(), (String)subscribedNode.getRootNodeId());
            this.subscriptionService.removeSubscriptions(this.serverId, subscribedNode.getDeviceTypeId(), rootNodeId2);
        }
        if (Objects.isNull(serverMappedNodes) || CollectionUtils.isEmpty((Collection)serverMappedNodes.getMappings())) {
            return;
        }
        for (DeviceTypeMappedNode mappedNode : serverMappedNodes.getMappings()) {
            try {
                this.updateSubscriptionForMappedNode((OpcuaClient)clientOptional.get(), mappedNode);
            }
            catch (OpcuaClientException e) {
                log.error("Unable to update subscription for device type mapped node, raising an alarm and retry next round: {}", (Object)mappedNode, (Object)e);
                this.createAlarmForFailedSubscriptionUpdate(this.serverId, mappedNode, e.getMessage());
            }
        }
    }

    private void updateSubscriptionForMappedNode(OpcuaClient client, DeviceTypeMappedNode mappedNode) throws OpcuaClientException, ServerNotConnectedException {
        String deviceTypeId = mappedNode.getDeviceTypeId();
        String rootNodeId = NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)mappedNode.getNodeId());
        mappedNode.setNodeId(rootNodeId);
        Optional appliedNodeOptional = this.subscriptionRepository.getAppliedNode(this.serverId, deviceTypeId, rootNodeId);
        if (this.isDeviceTypeUpdateItemsEmpty()) {
            if (!appliedNodeOptional.isPresent()) {
                try {
                    DeviceType deviceTypeFromRepository = this.deviceTypeRepository.getDeviceType(deviceTypeId);
                    log.info("Adding subscription for node: {} on server: {} with device type: {}", new Object[]{mappedNode.getNodeId(), this.serverId, deviceTypeFromRepository.getId()});
                    this.subscribeWithDeviceTypeAndNode(this.serverId, mappedNode, deviceTypeFromRepository);
                }
                catch (SDKException e) {
                    log.warn("Getting device type {} was not successful, skipping adding subscription", (Object)deviceTypeId, (Object)e);
                }
            }
        } else {
            DeviceType deviceTypeFromFetchedItems = (DeviceType)this.deviceTypeFetchedItems.getDeviceTypes().get(deviceTypeId);
            if (this.deviceTypeFetchedItems.isAllDeviceTypes() && Objects.isNull(deviceTypeFromFetchedItems)) {
                log.info("Device type has been removed: {}, removing subscription", (Object)deviceTypeId);
                this.subscriptionService.removeSubscriptions(this.serverId, Collections.singleton(deviceTypeId));
            }
            if (!Objects.isNull(deviceTypeFromFetchedItems)) {
                if (!appliedNodeOptional.isPresent()) {
                    log.info("Adding subscription for node: {} on server: {} with device type: {}", new Object[]{mappedNode.getNodeId(), this.serverId, deviceTypeFromFetchedItems.getId()});
                    this.subscribeWithDeviceTypeAndNode(this.serverId, mappedNode, deviceTypeFromFetchedItems);
                } else if (this.isDeviceTypeChanged(deviceTypeFromFetchedItems, (SubscribedNode)appliedNodeOptional.get())) {
                    log.info("Replace (remove -> add) subscription for node: {} on server: {} with device type: {}", new Object[]{mappedNode.getNodeId(), this.serverId, deviceTypeFromFetchedItems.getId()});
                    this.reSubscribeForDeviceTypeAndNode(this.serverId, mappedNode, deviceTypeFromFetchedItems);
                }
            }
        }
    }

    private boolean isDeviceTypeUpdateItemsEmpty() {
        return this.deviceTypeFetchedItems.getDeviceTypes().isEmpty() && !this.deviceTypeFetchedItems.isAllDeviceTypes();
    }

    private void reSubscribeForDeviceTypeAndNode(String serverId, DeviceTypeMappedNode mappedNode, DeviceType deviceType) throws OpcuaClientException, ServerNotConnectedException {
        Pair dataAndEvent = this.subscriptionDataResolver.resolve(serverId, deviceType, mappedNode);
        if (((Optional)dataAndEvent.getLeft()).isPresent() && !((SubscriptionData)((Optional)dataAndEvent.getLeft()).get()).isEmpty()) {
            this.subscriptionService.removeSubscriptions(serverId, mappedNode.getDeviceTypeId(), mappedNode.getNodeId());
            this.subscriptionService.applySubscriptions(serverId, (BaseSubscriptionData)((SubscriptionData)((Optional)dataAndEvent.getLeft()).get()));
        }
        if (((Optional)dataAndEvent.getRight()).isPresent() && !((SubscriptionEventData)((Optional)dataAndEvent.getRight()).get()).isEmpty()) {
            this.subscriptionService.removeSubscriptions(serverId, mappedNode.getDeviceTypeId(), mappedNode.getNodeId());
            this.subscriptionService.applySubscriptions(serverId, (BaseSubscriptionData)((SubscriptionEventData)((Optional)dataAndEvent.getRight()).get()));
        }
    }

    private void subscribeWithDeviceTypeAndNode(String serverId, DeviceTypeMappedNode mappedNode, DeviceType deviceType) throws OpcuaClientException, ServerNotConnectedException {
        Pair dataAndEvent = this.subscriptionDataResolver.resolve(serverId, deviceType, mappedNode);
        if (((Optional)dataAndEvent.getLeft()).isPresent() && !((SubscriptionData)((Optional)dataAndEvent.getLeft()).get()).isEmpty()) {
            this.subscriptionService.applySubscriptions(serverId, (BaseSubscriptionData)((SubscriptionData)((Optional)dataAndEvent.getLeft()).get()));
        }
        if (((Optional)dataAndEvent.getRight()).isPresent() && !((SubscriptionEventData)((Optional)dataAndEvent.getRight()).get()).isEmpty()) {
            this.subscriptionService.applySubscriptions(serverId, (BaseSubscriptionData)((SubscriptionEventData)((Optional)dataAndEvent.getRight()).get()));
        }
    }

    private void createAlarmForFailedSubscriptionUpdate(String serverId, DeviceTypeMappedNode mappedNode, String reason) {
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(GId.asGId((String)serverId));
        AlarmRepresentation alarm = new AlarmRepresentation();
        alarm.setSource(source);
        alarm.setType("c8y_ua_SubscriptionUpdateFailed");
        alarm.setSeverity(CumulocitySeverities.MAJOR.name());
        alarm.setDateTime(DateTime.now());
        if (Objects.nonNull(mappedNode)) {
            alarm.set((Object)mappedNode.getNodeId().concat(":").concat(mappedNode.getDeviceTypeId()));
            alarm.setText(String.format("Subscription update failed for node: %s and device type: %s, reason: %s", mappedNode.getNodeId(), mappedNode.getDeviceTypeId(), reason));
        } else {
            alarm.setText(reason);
        }
        this.alarmRepository.createAsync(alarm);
    }

    private boolean isDeviceTypeChanged(DeviceType deviceType, SubscribedNode subscribedNode) {
        if (Objects.isNull(deviceType.getLastUpdated()) || Objects.isNull(subscribedNode.getSubscribedAt())) {
            return true;
        }
        return deviceType.getLastUpdated().isAfter((ReadableInstant)subscribedNode.getSubscribedAt());
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setDeviceTypeFetchedItems(DeviceTypeFetchedItems deviceTypeFetchedItems) {
        this.deviceTypeFetchedItems = deviceTypeFetchedItems;
    }

    public void setForceReapply(boolean forceReapply) {
        this.forceReapply = forceReapply;
    }
}

