/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository.aggregate;

import com.cumulocity.opcua.client.gateway.platform.repository.QueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.aggregate.DataAggregator;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.TaskScheduler;

public class DataAggregateScheduler<T extends AbstractExtensibleRepresentation>
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DataAggregateScheduler.class);
    private final long fixedDelay;
    private final DataAggregator<T> aggregate;
    private final TaskScheduler taskScheduler;
    private final QueuedRepository<T> repository;

    public DataAggregateScheduler(long fixedDelay, DataAggregator<T> aggregate, TaskScheduler taskScheduler, QueuedRepository<T> repository) {
        this.fixedDelay = fixedDelay;
        this.aggregate = aggregate;
        this.taskScheduler = taskScheduler;
        this.repository = repository;
    }

    public void afterPropertiesSet() {
        this.doSchedule();
    }

    void doSchedule() {
        log.info("Start scheduling data aggregate with fixed delay: {} seconds", (Object)this.fixedDelay);
        this.taskScheduler.scheduleWithFixedDelay(() -> {
            Collection aggregatedData = this.aggregate.getAndClear();
            aggregatedData.forEach(arg_0 -> ((QueuedRepository)this.repository).addToQueue(arg_0));
        }, Duration.of(this.fixedDelay, ChronoUnit.SECONDS));
    }
}

