/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.monitoring.QueueMonitoringService;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.QueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.strategy.FlushExecutor;
import com.cumulocity.opcua.client.gateway.platform.repository.util.BulkElementsQueueOperation;
import com.cumulocity.opcua.client.gateway.platform.repository.util.ElementQueueOperation;
import com.cumulocity.rest.representation.measurement.MeasurementCollectionRepresentation;
import com.cumulocity.rest.representation.measurement.MeasurementRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.buffering.Future;
import com.cumulocity.sdk.client.measurement.MeasurementApi;
import com.cumulocity.sdk.client.measurement.MeasurementCollection;
import com.cumulocity.sdk.client.measurement.MeasurementFilter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class MeasurementRepository
extends BaseQueuedRepository<MeasurementRepresentation, List<MeasurementRepresentation>>
implements MeasurementApi,
QueuedRepository<MeasurementRepresentation> {
    private static final Logger log = LoggerFactory.getLogger(MeasurementRepository.class);
    @Autowired
    private MeasurementApi measurementApi;
    @Autowired
    private QueueMonitoringService queueMonitoringService;
    @Autowired
    @Qualifier(value="measurementsTaskExecutor")
    private ThreadPoolTaskExecutor executor;
    private final FlushExecutor<MeasurementRepresentation, List<MeasurementRepresentation>> bulkElementsFlushExecutor = new FlushExecutor((ElementQueueOperation)new BulkElementsQueueOperation((BaseQueuedRepository)this), (BaseQueuedRepository)this);

    public String getName() {
        return "Measurement Repository";
    }

    public void createElement(List<MeasurementRepresentation> measurementsToCreate) {
        MeasurementCollectionRepresentation collection = new MeasurementCollectionRepresentation();
        collection.setMeasurements(measurementsToCreate);
        this.measurementApi.createBulkWithoutResponse(collection);
        log.debug("{}: Flushed {} measurements with {} mode", new Object[]{this.getName(), measurementsToCreate.size(), this.getModeName()});
    }

    protected FlushExecutor<MeasurementRepresentation, List<MeasurementRepresentation>> getFlushStrategy() {
        return this.bulkElementsFlushExecutor;
    }

    public int getActiveThreads() {
        return this.executor.getActiveCount();
    }

    public int getQueuedThreads() {
        return this.executor.getThreadPoolExecutor().getQueue().size();
    }

    public GId getElementSource(MeasurementRepresentation element) {
        return element.getSource() != null ? element.getSource().getId() : null;
    }

    public ThreadPoolTaskExecutor getExecutor() {
        return this.executor;
    }

    public void reportExecutor() {
        this.queueMonitoringService.report("MeasurementRepository", Integer.valueOf(this.executor.getThreadPoolExecutor().getQueue().size()));
    }

    public void setExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }

    public MeasurementRepresentation getMeasurement(GId arg0) throws SDKException {
        return this.measurementApi.getMeasurement(arg0);
    }

    public MeasurementRepresentation create(MeasurementRepresentation arg0) throws SDKException {
        return this.measurementApi.create(arg0);
    }

    public void createWithoutResponse(MeasurementRepresentation arg0) throws SDKException {
        this.measurementApi.createWithoutResponse(arg0);
    }

    public MeasurementCollectionRepresentation createBulk(MeasurementCollectionRepresentation arg0) throws SDKException {
        return this.measurementApi.createBulk(arg0);
    }

    public void createBulkWithoutResponse(MeasurementCollectionRepresentation arg0) throws SDKException {
        this.measurementApi.createBulkWithoutResponse(arg0);
    }

    public Future createAsync(MeasurementRepresentation arg0) throws SDKException {
        return this.measurementApi.createAsync(arg0);
    }

    public void delete(MeasurementRepresentation arg0) throws SDKException {
        this.measurementApi.delete(arg0);
    }

    public void deleteMeasurementsByFilter(MeasurementFilter arg0) throws IllegalArgumentException, SDKException {
        this.measurementApi.deleteMeasurementsByFilter(arg0);
    }

    public MeasurementCollection getMeasurements() throws SDKException {
        return this.measurementApi.getMeasurements();
    }

    public MeasurementCollection getMeasurementsByFilter(MeasurementFilter arg0) throws SDKException {
        return this.measurementApi.getMeasurementsByFilter(arg0);
    }

    @Deprecated
    public void deleteMeasurement(MeasurementRepresentation arg0) throws SDKException {
        this.measurementApi.deleteMeasurement(arg0);
    }
}

