/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.monitoring.QueueMonitoringService;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.QueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.strategy.FlushExecutor;
import com.cumulocity.opcua.client.gateway.platform.repository.util.ElementQueueOperation;
import com.cumulocity.opcua.client.gateway.platform.repository.util.SingleElementQueueOperation;
import com.cumulocity.rest.representation.event.EventRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.buffering.Future;
import com.cumulocity.sdk.client.event.EventApi;
import com.cumulocity.sdk.client.event.EventCollection;
import com.cumulocity.sdk.client.event.EventFilter;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Repository;

@Repository
public class EventRepository
extends BaseQueuedRepository<EventRepresentation, EventRepresentation>
implements EventApi,
QueuedRepository<EventRepresentation> {
    private static final Logger log = LoggerFactory.getLogger(EventRepository.class);
    private final EventApi eventApi;
    @Autowired
    @Qualifier(value="eventsTaskExecutor")
    private ThreadPoolTaskExecutor executor;
    @Autowired
    private final QueueMonitoringService queueMonitoringService;
    private final FlushExecutor<EventRepresentation, EventRepresentation> singleElementFlushExecutor = new FlushExecutor((ElementQueueOperation)new SingleElementQueueOperation((BaseQueuedRepository)this), (BaseQueuedRepository)this);

    public String getName() {
        return "Event Repository";
    }

    public EventRepresentation createEvent(GId source, String type, String text) {
        ManagedObjectRepresentation sourceMO = new ManagedObjectRepresentation();
        sourceMO.setId(source);
        EventRepresentation event = new EventRepresentation();
        event.setDateTime(DateTime.now());
        event.setCreationDateTime(null);
        event.setSource(sourceMO);
        event.setType(type);
        event.setText(text);
        return this.eventApi.create(event);
    }

    public void createElement(EventRepresentation event) {
        this.eventApi.create(event);
    }

    protected FlushExecutor<EventRepresentation, EventRepresentation> getFlushStrategy() {
        return this.singleElementFlushExecutor;
    }

    public int getActiveThreads() {
        return this.executor.getActiveCount();
    }

    public int getQueuedThreads() {
        return this.executor.getThreadPoolExecutor().getQueue().size();
    }

    public GId getElementSource(EventRepresentation element) {
        return element.getSource() != null ? element.getSource().getId() : null;
    }

    public ThreadPoolTaskExecutor getExecutor() {
        return this.executor;
    }

    public void reportExecutor() {
        this.queueMonitoringService.report("EventRepository", Integer.valueOf(this.executor.getThreadPoolExecutor().getQueue().size()));
    }

    @Autowired
    public EventRepository(EventApi eventApi, QueueMonitoringService queueMonitoringService) {
        this.eventApi = eventApi;
        this.queueMonitoringService = queueMonitoringService;
    }

    public void setExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }

    public EventRepresentation getEvent(GId arg0) throws SDKException {
        return this.eventApi.getEvent(arg0);
    }

    public EventRepresentation create(EventRepresentation arg0) throws SDKException {
        return this.eventApi.create(arg0);
    }

    public Future createAsync(EventRepresentation arg0) throws SDKException {
        return this.eventApi.createAsync(arg0);
    }

    public void delete(EventRepresentation arg0) throws SDKException {
        this.eventApi.delete(arg0);
    }

    public void deleteEventsByFilter(EventFilter arg0) throws IllegalArgumentException, SDKException {
        this.eventApi.deleteEventsByFilter(arg0);
    }

    public EventCollection getEvents() throws SDKException {
        return this.eventApi.getEvents();
    }

    public EventCollection getEventsByFilter(EventFilter arg0) throws SDKException {
        return this.eventApi.getEventsByFilter(arg0);
    }

    public EventRepresentation update(EventRepresentation arg0) throws SDKException {
        return this.eventApi.update(arg0);
    }
}

