/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.configuration;

import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.platform.model.PlatformConfiguredEvent;
import com.cumulocity.opcua.client.gateway.platform.model.PlatformConnectionReadyEvent;
import com.cumulocity.opcua.client.gateway.platform.repository.interceptor.ProcessingModeHttpInterceptor;
import com.cumulocity.rest.representation.CumulocityMediaType;
import com.cumulocity.sdk.client.ConnectionPoolConfig;
import com.cumulocity.sdk.client.HttpClientConfig;
import com.cumulocity.sdk.client.Platform;
import com.cumulocity.sdk.client.PlatformBuilder;
import com.cumulocity.sdk.client.PlatformImpl;
import com.cumulocity.sdk.client.interceptor.HttpClientInterceptor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class PlatformProvider
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PlatformProvider.class);
    @Value(value="${gateway.platform.connectionPool.max}")
    private Integer platformConnectionPoolMax;
    @Value(value="${gateway.platform.connectionPool.perHost}")
    private Integer platformConnectionPoolPerHost;
    @Value(value="${gateway.platform.platformAvailCheckRetryDelay:10000}")
    private Integer platformAvailCheckRetryDelay = 10000;
    protected final String inventoryResource = "/inventory";
    private Platform platform;
    private Platform bootstrapPlatform;
    private final GatewayGeneralConfiguration gatewayGeneralConfiguration;
    private final ApplicationEventPublisher eventPublisher;

    public Platform get() {
        if (!this.isCredentialsAvailable()) {
            throw new IllegalStateException("Credentials are not available yet.");
        }
        return this.platform;
    }

    public Platform getBootstrapPlatform() {
        return this.bootstrapPlatform;
    }

    public boolean isCredentialsAvailable() {
        return this.platform != null;
    }

    @EventListener(value={PlatformConfiguredEvent.class})
    public void onPlatformConfigured(PlatformConfiguredEvent platformConfiguredEvent) throws InterruptedException {
        if (!this.isPlatformAvailable()) {
            log.warn("Platform currently does not seem to be reachable at {}. ", (Object)"/inventory");
            TimeUnit.MILLISECONDS.sleep(this.platformAvailCheckRetryDelay.intValue());
            this.eventPublisher.publishEvent((Object)platformConfiguredEvent);
        } else {
            log.info("Platform is up!");
            this.eventPublisher.publishEvent((Object)new PlatformConnectionReadyEvent(platformConfiguredEvent.getUserName()));
        }
    }

    public void afterPropertiesSet() {
        GatewayGeneralConfiguration.DeviceBootstrapConfiguration deviceBootstrapConfig = this.gatewayGeneralConfiguration.getBootstrapConfig();
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.builder().tenantId(deviceBootstrapConfig.getTenantId()).username(deviceBootstrapConfig.getUsername()).password(deviceBootstrapConfig.getPassword()).build();
        this.bootstrapPlatform = PlatformBuilder.platform().withBaseUrl(this.gatewayGeneralConfiguration.getBaseUrl()).withForceInitialHost(this.gatewayGeneralConfiguration.isForceInitialHost()).withCredentials((CumulocityCredentials)credentials).build();
    }

    protected boolean isPlatformAvailable() {
        try {
            Response.Status status = this.platform.rest().getStatus("/inventory", new CumulocityMediaType());
            return status.equals((Object)Response.Status.OK);
        }
        catch (Exception e) {
            log.warn("Error caught when checking platform availability: {}", (Object)e.getMessage());
            log.debug("Full stack exception : {}", (Throwable)e);
            return false;
        }
    }

    public void set(Platform platform, String userName) {
        log.info("Set platform and initializing http config.");
        this.platform = platform;
        ((PlatformImpl)platform).setHttpClientConfig(HttpClientConfig.httpConfig().pool(ConnectionPoolConfig.connectionPool().enabled(true).max(this.platformConnectionPoolMax.intValue()).perHost(this.platformConnectionPoolPerHost.intValue()).build()).build());
        ((PlatformImpl)platform).registerInterceptor((HttpClientInterceptor)new ProcessingModeHttpInterceptor());
        this.eventPublisher.publishEvent((Object)new PlatformConfiguredEvent(userName));
    }

    @Autowired
    public PlatformProvider(GatewayGeneralConfiguration gatewayGeneralConfiguration, ApplicationEventPublisher eventPublisher) {
        this.gatewayGeneralConfiguration = gatewayGeneralConfiguration;
        this.eventPublisher = eventPublisher;
    }

    public void setPlatformAvailCheckRetryDelay(Integer platformAvailCheckRetryDelay) {
        this.platformAvailCheckRetryDelay = platformAvailCheckRetryDelay;
    }

    void setPlatform(Platform platform) {
        this.platform = platform;
    }
}

