/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.configuration;

import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.model.authentication.CumulocityMqttJwtProviderAuthentication;
import com.cumulocity.model.authentication.jwt.ErrorListener;
import com.cumulocity.model.authentication.jwt.JwtMqttTopics;
import com.cumulocity.model.authentication.jwt.JwtMqttTopicsThinEdge;
import com.cumulocity.model.authentication.jwt.JwtToken;
import com.cumulocity.model.authentication.jwt.JwtTokenProvider;
import com.cumulocity.model.authentication.jwt.JwtTokenProviderListener;
import com.cumulocity.opcua.client.gateway.bootstrap.model.JWTAvailableEvent;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.sdk.client.Platform;
import com.cumulocity.sdk.client.PlatformBuilder;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component(value="platformFactoryThinEdge")
@ConditionalOnProperty(value={"gateway.thinEdge.enabled"}, havingValue="true", matchIfMissing=false)
public class PlatformFactoryThinEdge
implements ErrorListener,
JwtTokenProviderListener {
    private static final Logger log = LoggerFactory.getLogger(PlatformFactoryThinEdge.class);
    @Value(value="${gateway.thinEdge.mqttServerURL}")
    private String mqttServerUrl;
    @Value(value="${gateway.thinEdge.deviceId}")
    private String thinEdgeDeviceId;
    @Value(value="${gateway.thinEdge.mqttSteadyConnection}")
    private Boolean mqttSteadyConnection;
    private final PlatformProvider platformProvider;
    private final GatewayGeneralConfiguration gatewayGeneralConfiguration;
    private CumulocityMqttJwtProviderAuthentication credentials = new CumulocityMqttJwtProviderAuthentication();

    @EventListener
    public void onJWTAvailable(JWTAvailableEvent jwtAvailableEvent) {
        log.info("Create Platform for ThinEdge environment");
        if (this.platformProvider.isCredentialsAvailable()) {
            log.debug("Credentials are already available");
            return;
        }
        JwtTokenProvider jwtTokenProvider = null;
        try {
            log.debug("Initialize and start JWT provider.");
            jwtTokenProvider = new JwtTokenProvider(this.mqttServerUrl, new Properties(), this.thinEdgeDeviceId, (JwtTokenProviderListener)this, (ErrorListener)this, (JwtMqttTopics)new JwtMqttTopicsThinEdge(), this.mqttSteadyConnection.booleanValue());
            jwtTokenProvider.start();
        }
        catch (Exception e) {
            log.error("JWT token provider failed to initialize and to connect. Please Check MQTT configuration and ThinEdge! Gateway is shutting down...");
            System.exit(1);
        }
    }

    public void onError(ErrorListener.ErrorCode errorCode, String errorMessage) {
        log.error("Error, Code: " + errorCode.name() + ", Message: " + errorMessage);
        System.exit(1);
    }

    public void jwtTokenChange(JwtToken jwtToken) {
        this.credentials.jwtTokenChange(jwtToken);
        if (!this.platformProvider.isCredentialsAvailable()) {
            Platform platform = PlatformBuilder.platform().withBaseUrl(this.gatewayGeneralConfiguration.getBaseUrl()).withForceInitialHost(this.gatewayGeneralConfiguration.isForceInitialHost()).withCredentials((CumulocityCredentials)this.credentials).build();
            this.platformProvider.set(platform, this.credentials.getUsername());
        }
    }

    @Autowired
    public PlatformFactoryThinEdge(PlatformProvider platformProvider, GatewayGeneralConfiguration gatewayGeneralConfiguration) {
        this.platformProvider = platformProvider;
        this.gatewayGeneralConfiguration = gatewayGeneralConfiguration;
    }
}

