/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.configuration;

import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.opcua.client.gateway.bootstrap.model.CredentialsAvailableEvent;
import com.cumulocity.opcua.client.gateway.bootstrap.model.DeviceCredentials;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.sdk.client.Platform;
import com.cumulocity.sdk.client.PlatformBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component(value="platformFactoryStandard")
@ConditionalOnProperty(value={"gateway.thinEdge.enabled"}, havingValue="false", matchIfMissing=true)
public class PlatformFactoryStandard
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PlatformFactoryStandard.class);
    private final PlatformProvider platformProvider;
    private final GatewayGeneralConfiguration gatewayGeneralConfiguration;

    @EventListener
    public void onCredentialsAvailable(CredentialsAvailableEvent credentialsAvailableEvent) {
        if (this.platformProvider.isCredentialsAvailable()) {
            return;
        }
        log.info("Device credentials available, setting up platform connection");
        DeviceCredentials deviceCredentials = credentialsAvailableEvent.getDeviceCredentials();
        CumulocityBasicCredentials credentials = CumulocityBasicCredentials.builder().tenantId(deviceCredentials.getTenant()).username(deviceCredentials.getUsername()).password(deviceCredentials.getPassword()).build();
        Platform platform = PlatformBuilder.platform().withBaseUrl(this.gatewayGeneralConfiguration.getBaseUrl()).withForceInitialHost(this.gatewayGeneralConfiguration.isForceInitialHost()).withCredentials((CumulocityCredentials)credentials).build();
        this.platformProvider.set(platform, deviceCredentials.getUsername());
    }

    public void afterPropertiesSet() throws Exception {
        log.info("Standard PlatformFactory is loading...");
    }

    @Autowired
    public PlatformFactoryStandard(PlatformProvider platformProvider, GatewayGeneralConfiguration gatewayGeneralConfiguration) {
        this.platformProvider = platformProvider;
        this.gatewayGeneralConfiguration = gatewayGeneralConfiguration;
    }
}

