/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.monitoring;

import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.jmx.ServerMonitoringMBean;
import com.cumulocity.opcua.client.listener.OpcuaClientListener;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.ServerStatusDataType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(scopeName="prototype")
public class OpcuaServerStateChangeListener
implements OpcuaClientListener {
    private static final Logger log = LoggerFactory.getLogger(OpcuaServerStateChangeListener.class);
    static final String SERVER_NOT_RUNNING_ALARM_SEVERITY = "CRITICAL";
    private final ServerIdentifier serverIdentifier;
    private final ServerMonitoringMBean mbean;

    public void onShutdown(OpcuaClient uaClient, long secondsTillShutdown, LocalizedText shutdownReason) {
        log.warn("Server {} shutdown in {} seconds. Reason: {}", new Object[]{this.serverIdentifier, secondsTillShutdown, shutdownReason.getText()});
    }

    public void onStateChange(OpcuaClient uaClient, ServerState oldState, ServerState newState) {
        log.info("Server {} state changed from {} to {}", new Object[]{this.serverIdentifier, oldState, newState});
        if (newState.equals((Object)ServerState.CommunicationFault)) {
            log.debug("Got a connection fault. Increasing failed connection attempts for server {}", (Object)this.serverIdentifier.getName());
            this.mbean.increaseFailedConnectionAttemptsForServer(this.serverIdentifier.getName());
        }
    }

    public void onStatusChange(OpcuaClient uaClient, ServerStatusDataType serverStatusDataType, StatusCode statusCode) {
        log.debug("Heartbeat on server {}:  server state: {}, status code: {}", new Object[]{this.serverIdentifier, Objects.isNull(serverStatusDataType) ? null : serverStatusDataType.getState(), statusCode});
    }

    public OpcuaServerStateChangeListener(ServerIdentifier serverIdentifier, ServerMonitoringMBean mbean) {
        this.serverIdentifier = serverIdentifier;
        this.mbean = mbean;
    }

    public ServerIdentifier getServerIdentifier() {
        return this.serverIdentifier;
    }

    public ServerMonitoringMBean getMbean() {
        return this.mbean;
    }
}

