/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseTask;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.sdk.client.ProcessingMode;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import java.util.Objects;
import java.util.Optional;

public abstract class C8YBaseTask<T extends AbstractExtensibleRepresentation, Z>
extends BaseTask {
    private ProcessingMode processingMode;

    protected Optional<ProcessingMode> getProcessingMode() {
        return Optional.ofNullable(this.processingMode);
    }

    protected void addToQueue(T elementRepresentation) {
        if (this.getProcessingMode().isPresent()) {
            this.getRepository().addToQueue(elementRepresentation, this.processingMode);
        } else {
            this.getRepository().addToQueue(elementRepresentation);
        }
    }

    protected abstract BaseQueuedRepository<T, Z> getRepository();

    protected org.joda.time.DateTime getDateTimeWithFallBack(BaseDataValueEvent event) {
        if (Objects.nonNull(event.getValue().getSourceTimestamp())) {
            return new org.joda.time.DateTime(event.getValue().getSourceTimestamp().getTimeInMillis());
        }
        if (Objects.nonNull(event.getValue().getServerTimestamp())) {
            return new org.joda.time.DateTime(event.getValue().getServerTimestamp().getTimeInMillis());
        }
        return org.joda.time.DateTime.now();
    }

    protected Long getTimeStampOrNull(DateTime dateTime) {
        return Objects.nonNull(dateTime) ? Long.valueOf(dateTime.getValue()) : null;
    }

    public void setProcessingMode(ProcessingMode processingMode) {
        this.processingMode = processingMode;
    }
}

