/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.history.model.HistoryValuesReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.MappingExecutionTaskFactory;
import com.cumulocity.opcua.client.gateway.subscription.model.DataChangedEvent;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.cumulocity.opcua.common.model.mapping.ExecutableMappingAction;
import com.cumulocity.opcua.common.model.mapping.action.AlarmCreation;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class MappingsExecutor {
    private static final Logger log = LoggerFactory.getLogger(MappingsExecutor.class);
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private MappingExecutionTaskFactory factory;
    @Autowired
    @Qualifier(value="mappingsTaskExecutor")
    private TaskExecutor executor;

    @EventListener(value={ValueReadSuccessfulEvent.class})
    public void onValueReadSuccessfulEvent(ValueReadSuccessfulEvent event) {
        this.onValueDataArrived((BaseDataValueEvent)event);
    }

    @EventListener(value={DataChangedEvent.class})
    public void onValueDataChangedEvent(DataChangedEvent event) {
        this.onValueDataArrived((BaseDataValueEvent)event);
    }

    private <T extends BaseDataValueEvent> void onValueDataArrived(T event) {
        Collection mappings;
        log.debug("Processing value event: " + String.valueOf(event));
        if (event instanceof DataChangedEvent) {
            DataChangedEvent dataChangedEvent = (DataChangedEvent)event;
            mappings = this.subscriptionRepository.getMappedActions(dataChangedEvent.getServerId(), dataChangedEvent.getNodeId(), dataChangedEvent.getMonitoredItemId());
        } else if (event instanceof ValueReadSuccessfulEvent) {
            ValueReadSuccessfulEvent valueReadEvent = (ValueReadSuccessfulEvent)event;
            mappings = valueReadEvent.getDeviceTypeId() != null && valueReadEvent.getRootNodeId() != null ? this.subscriptionRepository.getMappedActions(valueReadEvent.getServerId(), valueReadEvent.getNodeId(), valueReadEvent.getDeviceTypeId(), valueReadEvent.getRootNodeId()) : this.subscriptionRepository.getMappedActions(valueReadEvent.getServerId(), valueReadEvent.getNodeId());
        } else {
            throw new IllegalArgumentException("Unknown event type: " + String.valueOf(event.getClass()));
        }
        if (mappings.isEmpty() && log.isDebugEnabled()) {
            log.debug("No mappings found!");
        }
        for (ExecutableMappingAction mapping : mappings) {
            log.debug("Applying mapping " + mapping.getClass().getName());
            this.executor.execute(this.factory.create(mapping, event, GId.asGId((Object)mapping.getSourceDeviceId()), false));
        }
    }

    @EventListener(value={HistoryValuesReadSuccessfulEvent.class})
    public void onHistoryValuesReadSuccessfulEvent(HistoryValuesReadSuccessfulEvent event) {
        this.onHistoryDataArrived(event);
    }

    private void onHistoryDataArrived(HistoryValuesReadSuccessfulEvent event) {
        log.debug("Processing history value event: " + String.valueOf(event));
        if (event.getValues() == null) {
            log.debug("No history value found");
            return;
        }
        Collection mappings = this.subscriptionRepository.getMappedActions(event.getServerId(), event.getNodeId());
        for (ExecutableMappingAction mapping : mappings) {
            MappingAction mappingAction = mapping.getMappingAction();
            if (mappingAction instanceof AlarmCreation) continue;
            for (DataValue value : event.getValues()) {
                if (value.getStatusCode().isGood()) {
                    ValueReadSuccessfulEvent dataValueEvent = new ValueReadSuccessfulEvent(event.getServerId(), event.getNodeId(), value);
                    log.debug("Applying historic mapping " + mapping.getClass().getName());
                    this.executor.execute(this.factory.createHistoric(mapping, event.getIsTaggingEnabled().booleanValue(), (BaseDataValueEvent)dataValueEvent, GId.asGId((Object)mapping.getSourceDeviceId())));
                    continue;
                }
                log.warn("There was a problem reading historic value: " + String.valueOf(value) + " Skipping this read.");
            }
        }
    }

    public int getActiveThreads() {
        return ((ThreadPoolTaskExecutor)this.executor).getActiveCount();
    }

    public int getQueuedThreads() {
        return ((ThreadPoolTaskExecutor)this.executor).getThreadPoolExecutor().getQueue().size();
    }
}

