/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappings;

import c8y.ua.Node;
import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.DeviceTypeMatchingDiagnostic;
import c8y.ua.data.MappedTargetNode;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.BaseDeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.BrowsePathsMatcher;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.NodeMatcher;
import com.cumulocity.opcua.client.gateway.mappings.RegexBrowsePathMatcher;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RegexDeviceTypeMatchingService
extends BaseDeviceTypeMatchingService
implements DeviceTypeMatchingService {
    private static final Logger log = LoggerFactory.getLogger(RegexDeviceTypeMatchingService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DeviceTypeMappedNode> matches(String serverId, List<DeviceType> deviceTypes, boolean includeInactiveDeviceProtocols) throws ServerNotConnectedException, OpcuaClientException {
        log.info("Finding matching nodes in server: " + serverId);
        OpcuaClient client = this.connectionManager.getClient(serverId);
        List addressSpace = this.retrieveAddressSpace(serverId, client);
        HashSet<DeviceTypeMappedNode> result = new HashSet<DeviceTypeMappedNode>();
        for (DeviceType deviceType : deviceTypes) {
            Instant start;
            Collection dataTypeResult;
            block5: {
                log.info("Start matching device type: {} with address space of server: {}", (Object)deviceType.getId(), (Object)serverId);
                dataTypeResult = null;
                start = Instant.now();
                try {
                    dataTypeResult = this.matchDeviceType(serverId, deviceType, addressSpace, client, includeInactiveDeviceProtocols);
                    if (CollectionUtils.isEmpty((Collection)dataTypeResult)) break block5;
                    result.addAll(dataTypeResult);
                }
                catch (Throwable throwable) {
                    try {
                        log.error("Unable to match device type: {} with address space of server: {}", new Object[]{deviceType.getId(), serverId, throwable});
                    }
                    catch (Throwable throwable2) {
                        log.info("Finished matching device type: {} with address space of server: {}, {} matching nodes: {}, took: {} seconds", new Object[]{deviceType.getId(), serverId, Objects.isNull(dataTypeResult) ? 0 : dataTypeResult.size(), Objects.isNull(dataTypeResult) ? "[]" : dataTypeResult.stream().map(DeviceTypeMappedNode::getNodeId).collect(Collectors.toSet()), Duration.between(start, Instant.now()).getSeconds()});
                        throw throwable2;
                    }
                    log.info("Finished matching device type: {} with address space of server: {}, {} matching nodes: {}, took: {} seconds", new Object[]{deviceType.getId(), serverId, Objects.isNull(dataTypeResult) ? 0 : dataTypeResult.size(), Objects.isNull(dataTypeResult) ? "[]" : dataTypeResult.stream().map(DeviceTypeMappedNode::getNodeId).collect(Collectors.toSet()), Duration.between(start, Instant.now()).getSeconds()});
                    continue;
                }
            }
            log.info("Finished matching device type: {} with address space of server: {}, {} matching nodes: {}, took: {} seconds", new Object[]{deviceType.getId(), serverId, Objects.isNull(dataTypeResult) ? 0 : dataTypeResult.size(), Objects.isNull(dataTypeResult) ? "[]" : dataTypeResult.stream().map(DeviceTypeMappedNode::getNodeId).collect(Collectors.toSet()), Duration.between(start, Instant.now()).getSeconds()});
        }
        return result;
    }

    public DeviceTypeMatchingDiagnostic testMatching(String serverId, DeviceType deviceType, String rootNodeId) throws OpcuaClientException {
        Collection targetNodes;
        Optional<MappedTargetNode> nodeValueNotSupported;
        Node matchedRootNode;
        OpcuaClient client;
        try {
            client = this.connectionManager.getClient(serverId);
        }
        catch (ServerNotConnectedException e) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Server: %s is not connected to the gateway", serverId));
        }
        String rootNodeIdWithNsUri = NodeIds.toNodeIdWithNsUri((NamespaceTable)client.getNamespaceTable(), (String)rootNodeId);
        DeviceTypeMatchingDiagnostic diagnostic = this.diagnoseServerSpecificConstraints(serverId, deviceType, client);
        if (Objects.nonNull(diagnostic) && !diagnostic.isMatches()) {
            return diagnostic;
        }
        if (deviceType.hasApplyConstraints() && NodeMatcher.nonMatchNodeIdsConstraint((String)rootNodeId, (NamespaceTable)client.getNamespaceTable(), (Collection)deviceType.getApplyConstraints().getMatchesNodeIds())) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Does not match node ids constraint, constraints: %s, actual: %s", deviceType.getApplyConstraints().getMatchesNodeIds(), rootNodeId));
        }
        List addressSpace = this.retrieveAddressSpace(serverId, client);
        RegexBrowsePathMatcher.BrowsePathMatchingResult dataResult = RegexBrowsePathMatcher.matchRegexBrowsePaths((NamespaceTable)client.getNamespaceTable(), (List)addressSpace, (String)deviceType.getId(), (Collection)deviceType.getMappings());
        if (dataResult.hasNonMatch()) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Browse paths do not match: %s", dataResult.nonMatchBrowsePaths));
        }
        RegexBrowsePathMatcher.BrowsePathMatchingResult eventResult = RegexBrowsePathMatcher.matchRegexBrowsePaths((NamespaceTable)client.getNamespaceTable(), (List)addressSpace, (String)deviceType.getId(), (Collection)deviceType.getUaEventMappings());
        if (eventResult.hasNonMatch()) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Browse paths of ua event mappings do not match: %s", eventResult.nonMatchBrowsePaths));
        }
        if (dataResult.hasMatchedNodes() || eventResult.hasMatchedNodes()) {
            if (!dataResult.matchedNodesMap.containsKey(rootNodeIdWithNsUri) && !eventResult.matchedNodesMap.containsKey(rootNodeIdWithNsUri)) {
                return DeviceTypeMatchingDiagnostic.nonMatch((String)"One or more browse path mappings do not match");
            }
        } else {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)"One or more browse path mapping do not match. Actually there is no matching node found for this device type");
        }
        if (deviceType.hasApplyConstraints() && !StringUtils.isEmpty((Object)deviceType.getApplyConstraints().getBrowsePathMatchesRegex()) && Objects.nonNull(matchedRootNode = dataResult.matchedNodesMap.getOrDefault(rootNodeIdWithNsUri, (Node)eventResult.matchedNodesMap.get(rootNodeIdWithNsUri))) && BrowsePathsMatcher.nonMatchBrowsePathRegex((Node)matchedRootNode, (String)deviceType.getApplyConstraints().getBrowsePathMatchesRegex())) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Does not match browse path regex constraint, constraints: %s, actual: %s", deviceType.getApplyConstraints().getBrowsePathMatchesRegex(), matchedRootNode.getAbsolutePaths()));
        }
        if (!CollectionUtils.isEmpty((Collection)dataResult.matchedNodes) && this.hasCyclicRead(deviceType) && (nodeValueNotSupported = (targetNodes = (Collection)dataResult.matchedNodes.stream().map(DeviceTypeMappedNode::getMappedTargetNodes).flatMap(Collection::stream).collect(Collectors.toSet())).stream().filter(targetNode -> NodeMatcher.nonSupportsValueAttribute((OpcuaClient)client, (String)targetNode.getTargetNodeId())).findFirst()).isPresent()) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("One or more mappings targeting to a node which does not support Value attribute. For example: %s", nodeValueNotSupported.get()));
        }
        return new DeviceTypeMatchingDiagnostic(true);
    }

    protected Collection<DeviceTypeMappedNode> matchDeviceType(String serverId, DeviceType deviceType, List<Node> addressSpace, OpcuaClient client, boolean includeInactiveDeviceProtocols) {
        RegexBrowsePathMatcher.BrowsePathMatchingResult eventResult;
        List workingDeviceTypes = this.applyServerSpecificConstraints(serverId, Collections.singletonList(deviceType), includeInactiveDeviceProtocols, client);
        if (CollectionUtils.isEmpty((Collection)workingDeviceTypes)) {
            return this.nonMatchWithReason(deviceType, serverId, "does not meet the constraints specifically defined for the given server");
        }
        HashSet<DeviceTypeMappedNode> allMatchingRootNodes = new HashSet<DeviceTypeMappedNode>();
        RegexBrowsePathMatcher.BrowsePathMatchingResult dataResult = RegexBrowsePathMatcher.matchRegexBrowsePaths((NamespaceTable)client.getNamespaceTable(), addressSpace, (String)deviceType.getId(), (Collection)deviceType.getMappings());
        if (dataResult.hasNonMatch()) {
            return this.nonMatchWithReason(deviceType, serverId, "there are non-matching browse path(s)");
        }
        if (this.hasCyclicRead(deviceType) && !CollectionUtils.isEmpty((Collection)dataResult.matchedNodes)) {
            dataResult.matchedNodes.removeIf(matchingRootNode -> {
                Collection targetNodes = matchingRootNode.getMappedTargetNodes();
                Optional<MappedTargetNode> nodeValueNotSupported = targetNodes.stream().filter(targetNode -> NodeMatcher.nonSupportsValueAttribute((OpcuaClient)client, (String)NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)targetNode.getTargetNodeId()))).findFirst();
                if (nodeValueNotSupported.isPresent()) {
                    log.debug("One or more mappings targeting to a node which does not support Value attribute. For example: {}", (Object)nodeValueNotSupported.get());
                    return true;
                }
                return false;
            });
        }
        if ((eventResult = RegexBrowsePathMatcher.matchRegexBrowsePaths((NamespaceTable)client.getNamespaceTable(), addressSpace, (String)deviceType.getId(), (Collection)deviceType.getUaEventMappings())).hasNonMatch()) {
            return this.nonMatchWithReason(deviceType, serverId, "there are non-matching browse path(s) in ua events");
        }
        allMatchingRootNodes.addAll(dataResult.matchedNodes);
        allMatchingRootNodes.addAll(eventResult.matchedNodes);
        if (CollectionUtils.isEmpty(allMatchingRootNodes)) {
            return this.nonMatchWithReason(deviceType, serverId, "no matching node found");
        }
        if (deviceType.hasApplyConstraints() && !CollectionUtils.isEmpty((Collection)deviceType.getApplyConstraints().getMatchesNodeIds())) {
            allMatchingRootNodes.removeIf(matchingRootNode -> {
                boolean nonMatch = NodeMatcher.nonMatchNodeIdsConstraint((String)matchingRootNode.getNodeId(), (NamespaceTable)client.getNamespaceTable(), (Collection)deviceType.getApplyConstraints().getMatchesNodeIds());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Does not match node ids constraint, constraints: %s, actual: %s", deviceType.getApplyConstraints().getMatchesNodeIds(), matchingRootNode));
                }
                return nonMatch;
            });
        }
        if (CollectionUtils.isEmpty(allMatchingRootNodes)) {
            return this.nonMatchWithReason(deviceType, serverId, "does not meet 'matchesNodeIds' constraints");
        }
        if (deviceType.hasApplyConstraints() && !StringUtils.isEmpty((Object)deviceType.getApplyConstraints().getBrowsePathMatchesRegex())) {
            allMatchingRootNodes.removeIf(matchingRootNode -> {
                boolean nonMatchBrowsePathRegex;
                Node matchedRootNode = dataResult.matchedNodesMap.getOrDefault(matchingRootNode.getNodeId(), (Node)eventResult.matchedNodesMap.get(matchingRootNode.getNodeId()));
                boolean bl = nonMatchBrowsePathRegex = Objects.nonNull(matchedRootNode) && BrowsePathsMatcher.nonMatchBrowsePathRegex((Node)matchedRootNode, (String)deviceType.getApplyConstraints().getBrowsePathMatchesRegex());
                if (nonMatchBrowsePathRegex && log.isDebugEnabled()) {
                    log.debug(String.format("Does not match browse path regex constraint, constraints: %s, actual: %s", deviceType.getApplyConstraints().getBrowsePathMatchesRegex(), matchedRootNode.getAbsolutePaths()));
                }
                return nonMatchBrowsePathRegex;
            });
        }
        if (CollectionUtils.isEmpty(allMatchingRootNodes)) {
            return this.nonMatchWithReason(deviceType, serverId, "does not meet 'browsePathMatchesRegex' constraints");
        }
        return allMatchingRootNodes;
    }

    private Collection<DeviceTypeMappedNode> nonMatchWithReason(DeviceType deviceType, String serverId, String reason) {
        log.info("Device type: {} does not match any node in server: {}, reason: {}", new Object[]{deviceType.getId(), serverId, reason});
        return Collections.emptySet();
    }
}

