/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappings;

import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.DeviceTypeMatchingDiagnostic;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.RegexDeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.RegularDeviceTypeMatchingService;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Primary
public class CompositeDeviceTypeMatchingService
implements DeviceTypeMatchingService {
    @Autowired
    private RegularDeviceTypeMatchingService regularDeviceTypeMatchingService;
    @Autowired
    private RegexDeviceTypeMatchingService regexDeviceTypeMatchingService;

    public Collection<DeviceTypeMappedNode> matches(String serverId, List<DeviceType> deviceTypes, boolean includeInactiveDeviceProtocols) throws ServerNotConnectedException, OpcuaClientException {
        Collection deviceTypeResult;
        HashSet<DeviceTypeMappedNode> result = new HashSet<DeviceTypeMappedNode>();
        ArrayList<DeviceType> regexDeviceTypes = new ArrayList<DeviceType>();
        ArrayList<DeviceType> regularDeviceTypes = new ArrayList<DeviceType>();
        for (DeviceType deviceType : deviceTypes) {
            if (deviceType.isRegexUsed()) {
                regexDeviceTypes.add(deviceType);
                continue;
            }
            regularDeviceTypes.add(deviceType);
        }
        if (!regexDeviceTypes.isEmpty() && !CollectionUtils.isEmpty((Collection)(deviceTypeResult = this.regexDeviceTypeMatchingService.matches(serverId, regexDeviceTypes, includeInactiveDeviceProtocols)))) {
            result.addAll(deviceTypeResult);
        }
        if (!regularDeviceTypes.isEmpty() && !CollectionUtils.isEmpty((Collection)(deviceTypeResult = this.regularDeviceTypeMatchingService.matches(serverId, regularDeviceTypes, includeInactiveDeviceProtocols)))) {
            result.addAll(deviceTypeResult);
        }
        return result;
    }

    public DeviceTypeMatchingDiagnostic testMatching(String serverId, DeviceType deviceType, String rootNodeId) throws OpcuaClientException, ServerNotConnectedException {
        if (deviceType.isRegexUsed()) {
            return this.regexDeviceTypeMatchingService.testMatching(serverId, deviceType, rootNodeId);
        }
        return this.regularDeviceTypeMatchingService.testMatching(serverId, deviceType, rootNodeId);
    }
}

