/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappings;

import c8y.ua.Node;
import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.DeviceTypeMatchingDiagnostic;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.AddressSpaceScanner;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.BrowsePathsMatcher;
import com.cumulocity.opcua.client.gateway.mappings.NodeMatcher;
import com.cumulocity.opcua.common.model.mapping.ApplyConstraints;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.cumulocity.opcua.common.model.mapping.MatchingCondition;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.google.common.collect.Lists;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

abstract class BaseDeviceTypeMatchingService {
    private static final Logger log = LoggerFactory.getLogger(BaseDeviceTypeMatchingService.class);
    @Autowired
    protected InventoryRepository inventoryRepository;
    @Autowired
    protected ConnectionManager connectionManager;
    @Autowired
    protected AddressSpaceScanner addressSpaceScanner;

    BaseDeviceTypeMatchingService() {
    }

    public abstract Collection<DeviceTypeMappedNode> matches(String var1, List<DeviceType> var2, boolean var3) throws ServerNotConnectedException, OpcuaClientException;

    protected List<DeviceType> applyServerSpecificConstraints(String serverId, List<DeviceType> deviceTypes, boolean includeInactiveDeviceProtocols, OpcuaClient client) {
        ArrayList<DeviceType> workingDeviceTypes = new ArrayList<DeviceType>(deviceTypes);
        if (!includeInactiveDeviceProtocols) {
            this.removeDeviceTypesThatAreNotEnabled(workingDeviceTypes);
        }
        this.removeDeviceTypesThatHaveEmptyMappings(workingDeviceTypes);
        this.removeDeviceTypesThatDoNotMatchServerId(workingDeviceTypes, serverId);
        this.removeDeviceTypesThatDoNotMatchServerFragment(workingDeviceTypes, serverId);
        this.removeDeviceTypesThatDoNotMatchServerNodeValues(client, workingDeviceTypes);
        return workingDeviceTypes;
    }

    protected DeviceTypeMatchingDiagnostic diagnoseServerSpecificConstraints(String serverId, DeviceType deviceType, OpcuaClient client) {
        ArrayList deviceTypesForTesting = Lists.newArrayList((Object[])new DeviceType[]{deviceType});
        Optional firstDeviceTypeWithEmptyMapping = this.removeDeviceTypesThatHaveEmptyMappings((List)deviceTypesForTesting);
        if (firstDeviceTypeWithEmptyMapping.isPresent()) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Device type %s has one or more empty mappings. Either: mappings or uaEventMappings must be defined AND browsePath of every mapping entry must not be empty.", deviceType.getId()));
        }
        this.removeDeviceTypesThatDoNotMatchServerId((List)deviceTypesForTesting, serverId);
        if (CollectionUtils.isEmpty((Collection)deviceTypesForTesting)) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Does not match server ID constraint, constraints: %s, actual: %s", deviceType.getApplyConstraints().getMatchesServerIds(), serverId));
        }
        this.removeDeviceTypesThatDoNotMatchServerFragment((List)deviceTypesForTesting, serverId);
        if (CollectionUtils.isEmpty((Collection)deviceTypesForTesting)) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Does not match server fragment constraint, expected: %s", deviceType.getApplyConstraints().getServerObjectHasFragment()));
        }
        this.removeDeviceTypesThatDoNotMatchServerNodeValues(client, (Collection)deviceTypesForTesting);
        if (CollectionUtils.isEmpty((Collection)deviceTypesForTesting)) {
            return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Does not match server node values constraint, expected: %s", deviceType.getApplyConstraints().getServerHasNodeWithValues()));
        }
        return null;
    }

    protected DeviceTypeMatchingDiagnostic diagnoseMatchesNodeIdsConstraints(DeviceType deviceType, String rootNodeId, Node rootNode, NamespaceTable namespaceTable) {
        ApplyConstraints applyConstraints = deviceType.getApplyConstraints();
        if (applyConstraints != null) {
            if (NodeMatcher.nonMatchNodeIdsConstraint((String)rootNode.getNodeId(), (NamespaceTable)namespaceTable, (Collection)applyConstraints.getMatchesNodeIds())) {
                return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Does not match node ids constraint, constraints: %s, actual: %s", applyConstraints.getMatchesNodeIds(), rootNodeId));
            }
            if (BrowsePathsMatcher.nonMatchBrowsePathRegex((Node)rootNode, (String)applyConstraints.getBrowsePathMatchesRegex())) {
                return DeviceTypeMatchingDiagnostic.nonMatch((String)String.format("Does not match browse path regex constraint, constraints: %s, actual: %s", applyConstraints.getBrowsePathMatchesRegex(), rootNode.getAbsolutePaths()));
            }
        }
        return null;
    }

    protected List<Node> retrieveAddressSpace(String serverId, OpcuaClient client) throws OpcuaClientException {
        long start = System.currentTimeMillis();
        log.info("Retrieving address space for device type matching of server: {}", (Object)serverId);
        List addressSpace = this.addressSpaceScanner.scan(client, serverId, false, true);
        long end = System.currentTimeMillis();
        log.info("Got address space in: {} milliseconds", (Object)(end - start));
        return addressSpace;
    }

    protected void removeDeviceTypesThatAreNotEnabled(List<DeviceType> deviceTypes) {
        deviceTypes.removeIf(dt -> !dt.isEnabled());
    }

    protected Optional<DeviceType> removeDeviceTypesThatHaveEmptyMappings(List<DeviceType> deviceTypes) {
        AtomicReference dtReference = new AtomicReference();
        deviceTypes.removeIf(dt -> {
            boolean empty = false;
            if (!CollectionUtils.isEmpty((Collection)dt.getMappings())) {
                empty = BrowsePathsMatcher.emptyBrowsePath((Collection)dt.getMappings());
            }
            if (!empty && !CollectionUtils.isEmpty((Collection)dt.getUaEventMappings())) {
                return BrowsePathsMatcher.emptyBrowsePath((Collection)dt.getUaEventMappings());
            }
            if (empty) {
                dtReference.set(dt);
            }
            return empty;
        });
        return Optional.ofNullable((DeviceType)dtReference.get());
    }

    protected void removeDeviceTypesThatDoNotMatchServerId(List<DeviceType> deviceTypes, String serverId) {
        deviceTypes.removeIf(dt -> Objects.nonNull(dt.getApplyConstraints()) && !CollectionUtils.isEmpty((Collection)dt.getApplyConstraints().getMatchesServerIds()) && !dt.getApplyConstraints().getMatchesServerIds().contains(serverId));
    }

    protected void removeDeviceTypesThatDoNotMatchServerFragment(List<DeviceType> deviceTypes, String serverId) {
        ManagedObjectRepresentation serverMo = this.inventoryRepository.get(GId.asGId((String)serverId));
        deviceTypes.removeIf(dt -> Objects.nonNull(dt.getApplyConstraints()) && Objects.nonNull(dt.getApplyConstraints().getServerObjectHasFragment()) && !StringUtils.isEmpty((Object)dt.getApplyConstraints().getServerObjectHasFragment()) && !serverMo.hasProperty(dt.getApplyConstraints().getServerObjectHasFragment()));
    }

    protected void removeDeviceTypesThatDoNotMatchServerNodeValues(OpcuaClient client, Collection<DeviceType> deviceTypes) {
        deviceTypes.removeIf(dt -> Objects.nonNull(dt.getApplyConstraints()) && Objects.nonNull(dt.getApplyConstraints().getServerHasNodeWithValues()) && !NodeMatcher.matchServerWithNodeValues((OpcuaClient)client, (MatchingCondition)dt.getApplyConstraints().getServerHasNodeWithValues()));
    }

    protected boolean hasCyclicRead(DeviceType deviceType) {
        boolean hasCyclicRead = false;
        if ("CyclicRead".equalsIgnoreCase(deviceType.getSubscriptionType().getType())) {
            hasCyclicRead = true;
        }
        if (!hasCyclicRead && !CollectionUtils.isEmpty((Collection)deviceType.getOverriddenSubscriptions())) {
            hasCyclicRead = deviceType.getOverriddenSubscriptions().stream().anyMatch(subscription -> "CyclicRead".equalsIgnoreCase(subscription.getSubscriptionType().getType()));
        }
        return hasCyclicRead;
    }

    public void setAddressSpaceScanner(AddressSpaceScanner addressSpaceScanner) {
        this.addressSpaceScanner = addressSpaceScanner;
    }
}

