/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.datastore;

import com.cumulocity.opcua.client.gateway.datastore.DataStore;
import com.cumulocity.opcua.client.gateway.datastore.kryo.KryoContext;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSpaceFileDataStore
implements DataStore {
    private static final Logger log = LoggerFactory.getLogger(AddressSpaceFileDataStore.class);
    private String databasePath;
    private KryoContext kryoContext;

    public AddressSpaceFileDataStore(String databasePath, boolean cleanupLegacyAddressSpaceLocalDb) {
        this.initializeDbPathAndKryo(databasePath);
        if (cleanupLegacyAddressSpaceLocalDb) {
            this.removeLegacyFiles();
        }
    }

    private void initializeDbPathAndKryo(String databasePath) {
        this.databasePath = databasePath;
        this.kryoContext = new KryoContext(kryo -> kryo.register(ArrayList.class));
    }

    public void store(String collection, String key, Serializable value, long ttl) {
        this.store(key, value);
    }

    public void store(String key, Serializable value) {
        File file = this.getFile(key);
        try {
            if (file.exists()) {
                log.info("Address space file for server {} already exists, removing the file", (Object)key);
                this.remove(key);
            }
            log.info("Storing address space for server {} to the file", (Object)key);
            this.kryoContext.serializeToFile(file, (Object)value);
            log.info("Address space for server {} is stored to the file", (Object)key);
        }
        catch (FileNotFoundException e) {
            log.error("Address space for server {} cannot be stored to the file", (Object)key, (Object)e);
        }
    }

    public Optional<List> get(String key) {
        File file = this.getFile(key);
        try {
            if (!file.exists()) {
                return Optional.empty();
            }
            log.debug("Retrieve address space for server {} from file", (Object)key);
            List deserialized = (List)this.kryoContext.deserializeFromFile(file, ArrayList.class);
            return Optional.of(deserialized);
        }
        catch (FileNotFoundException e) {
            log.error("Address space for server {} cannot be restored from the file", (Object)key, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<List> get(String collection, String key) {
        return this.get(key);
    }

    public Optional<List> remove(String collection, String key) {
        Optional previousVal = this.get(key);
        this.remove(key);
        return previousVal;
    }

    public void remove(String key) {
        File file = this.getFile(key);
        file.delete();
        log.debug("Address space file for server {} is removed", (Object)key);
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    private File getFile(String key) {
        String filename = String.format("cumulocity-opcua-server-%s-address-space-pv4.bin", key);
        File dbFile = Paths.get(this.databasePath, filename).toFile();
        return dbFile;
    }

    private void removeLegacyFiles() {
        String filenameRegex = String.format("cumulocity-opcua-server-%s-address-space.bin", "\\w+");
        RegexFileFilter fileFilter = new RegexFileFilter(filenameRegex);
        File fileBase = new File(this.databasePath);
        try {
            File[] legacyDbFiles = fileBase.listFiles((FileFilter)fileFilter);
            if (Objects.isNull(legacyDbFiles)) {
                return;
            }
            for (File legacyDbFile : legacyDbFiles) {
                log.info("Found legacy server address space local db file. Removing {}", (Object)legacyDbFile.getName());
                try {
                    legacyDbFile.delete();
                }
                catch (SecurityException e) {
                    log.error("Removal of the {} file failed.", (Object)legacyDbFile.getName(), (Object)e);
                }
            }
        }
        catch (SecurityException e) {
            log.warn("Check for the legacy server address space local db files failed.", (Throwable)e);
        }
    }
}

