/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class ConcurrencyConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ConcurrencyConfiguration.class);
    @Value(value="${gateway.scheduler.threadpool.size:15}")
    private Integer schedulerPoolSize;
    @Value(value="${gateway.executor.threadpool.coreSize:30}")
    private Integer executorCorePoolSize;
    @Value(value="${gateway.executor.threadpool.maxSize:60}")
    private Integer executorMaxPoolSize;
    @Value(value="${gateway.cyclicRead.threadpool.size:30}")
    private Integer crPoolSize;
    @Value(value="${gateway.mappingExecution.threadpool.size:60}")
    private Integer mappingExecutionPoolSize;
    @Value(value="${gateway.repositories.eventsThreadpool:20}")
    private Integer eventsThreadPoolSize;
    @Value(value="${gateway.repositories.alarmsThreadpool:20}")
    private Integer alarmsThreadPoolSize;
    @Value(value="${gateway.repositories.measurementsThreadpool:20}")
    private Integer measurementsThreadPoolSize;
    @Value(value="${gateway.mappingExecution.http.threadPoolSize:200}")
    private Integer httpPostThreadPoolSize;
    @Value(value="${gateway.mappingExecution.http.maxQueueSize:50000}")
    private Integer httpPostMaxQueueSize;

    public void afterPropertiesSet() {
        log.info("Gateway concurrency configuration: {}", (Object)this);
    }

    @Bean
    @Primary
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(this.schedulerPoolSize.intValue());
        threadPoolTaskScheduler.setThreadNamePrefix("scheduler-");
        return threadPoolTaskScheduler;
    }

    @Bean(value={"cyclicReadTaskScheduler"})
    public ThreadPoolTaskScheduler cyclicReadTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(this.crPoolSize.intValue());
        threadPoolTaskScheduler.setThreadNamePrefix("reader-");
        return threadPoolTaskScheduler;
    }

    @Bean(value={"taskExecutor"})
    @Primary
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        return this.createExecutor(this.executorCorePoolSize.intValue(), this.executorMaxPoolSize.intValue(), "background-");
    }

    @Bean(value={"mappingsTaskExecutor"})
    public ThreadPoolTaskExecutor mappingsTaskExecutor() {
        return this.createExecutor(this.mappingExecutionPoolSize.intValue(), this.mappingExecutionPoolSize.intValue(), "mapping-");
    }

    @Bean(value={"eventsTaskExecutor"})
    public ThreadPoolTaskExecutor repositoriesTaskExecutor() {
        return this.createExecutor(this.eventsThreadPoolSize / 2, this.eventsThreadPoolSize.intValue(), "flushEvents-");
    }

    @Bean(value={"alarmsTaskExecutor"})
    public ThreadPoolTaskExecutor alarmsTaskExecutor() {
        return this.createExecutor(this.alarmsThreadPoolSize / 2, this.alarmsThreadPoolSize.intValue(), "flushAlarms-");
    }

    @Bean(value={"measurementsTaskExecutor"})
    public ThreadPoolTaskExecutor measurementsTaskExecutor() {
        return this.createExecutor(this.measurementsThreadPoolSize / 2, this.measurementsThreadPoolSize.intValue(), "flushMeasurements-");
    }

    @Bean(value={"httpPostTaskExecutor"})
    public ThreadPoolTaskExecutor httpPostTaskExecutor() {
        ThreadPoolTaskExecutor executor = this.createExecutor(this.httpPostThreadPoolSize / 2, this.httpPostThreadPoolSize.intValue(), "httpPost-");
        executor.setQueueCapacity(this.httpPostMaxQueueSize / 2);
        return executor;
    }

    private ThreadPoolTaskExecutor createExecutor(int core, int max, String prefix) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(core);
        executor.setMaxPoolSize(max);
        executor.setThreadNamePrefix(prefix);
        return executor;
    }

    public String toString() {
        return "ConcurrencyConfiguration(schedulerPoolSize=" + this.schedulerPoolSize + ", executorCorePoolSize=" + this.executorCorePoolSize + ", executorMaxPoolSize=" + this.executorMaxPoolSize + ", crPoolSize=" + this.crPoolSize + ", mappingExecutionPoolSize=" + this.mappingExecutionPoolSize + ", eventsThreadPoolSize=" + this.eventsThreadPoolSize + ", alarmsThreadPoolSize=" + this.alarmsThreadPoolSize + ", measurementsThreadPoolSize=" + this.measurementsThreadPoolSize + ", httpPostThreadPoolSize=" + this.httpPostThreadPoolSize + ", httpPostMaxQueueSize=" + this.httpPostMaxQueueSize + ")";
    }
}

