/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.addressspace.service.synchronizer;

import c8y.ua.Node;
import com.cumulocity.opcua.client.gateway.addressspace.exception.AbsPathResolveException;
import com.cumulocity.opcua.client.model.ReferenceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Synchronizer {
    private static final Logger log = LoggerFactory.getLogger(Synchronizer.class);

    public void removeParentChildRefIfStartNodeParentChanged(Node startNodeWithNsu, Set<List<String>> localStartNodeAncestorPaths, Set<List<String>> scannedStartNodeAncestorPaths, Function<String, Optional<Node>> findNodeFn, Consumer<Node> updateNodeFn) {
        if (Objects.isNull(localStartNodeAncestorPaths) || Objects.isNull(scannedStartNodeAncestorPaths)) {
            return;
        }
        if (localStartNodeAncestorPaths.equals(scannedStartNodeAncestorPaths)) {
            return;
        }
        for (List<String> localStartNodeAncestorPath : localStartNodeAncestorPaths) {
            String parentNodeIdWithNsu;
            Optional<Node> parentNode;
            if (scannedStartNodeAncestorPaths.contains(localStartNodeAncestorPath) || !(parentNode = findNodeFn.apply(parentNodeIdWithNsu = localStartNodeAncestorPath.get(localStartNodeAncestorPath.size() - 1))).isPresent()) continue;
            List referenceInfos = parentNode.get().getReferences();
            ReferenceInfo refToRemove = null;
            for (ReferenceInfo referenceInfo : referenceInfos) {
                if (referenceInfo.isInverse() || !startNodeWithNsu.getNodeId().equals(referenceInfo.getTargetId())) continue;
                refToRemove = referenceInfo;
                break;
            }
            if (!Objects.nonNull(refToRemove)) continue;
            referenceInfos.remove(refToRemove);
            updateNodeFn.accept(parentNode.get());
        }
    }

    public void updateAddressSpaceForDeletedNode(Node startNodeWithNsu, Node deletedNodeWithNsu, Function<String, Optional<Node>> findNodeFn, Consumer<Node> updateNodeFn, Consumer<String> deleteNodeFn) {
        boolean isSafeToDelete = true;
        log.info("Removal of node {} is detected in sub-tree", (Object)deletedNodeWithNsu.getNodeId());
        for (List ancestors : deletedNodeWithNsu.getAncestorNodeIds()) {
            String parentNodeId;
            Optional<Node> nodeMoMaybe;
            if (ancestors.contains(startNodeWithNsu.getNodeId()) || !(nodeMoMaybe = findNodeFn.apply(parentNodeId = (String)ancestors.get(ancestors.size() - 1))).isPresent()) continue;
            isSafeToDelete = false;
            break;
        }
        if (isSafeToDelete) {
            log.info("Node {} is safe to remove", (Object)deletedNodeWithNsu.getNodeId());
            deleteNodeFn.accept(deletedNodeWithNsu.getNodeId());
        } else {
            log.info("Node {} is removed from partial path but has still have other existing references. Removing only paths with partial scan start node", (Object)deletedNodeWithNsu.getNodeId());
            Set absPaths = deletedNodeWithNsu.getAbsolutePaths();
            Set ancestorNodeIds = deletedNodeWithNsu.getAncestorNodeIds();
            ArrayList<List> absPathsToRemove = new ArrayList<List>();
            ArrayList<List> ancestorsToRemove = new ArrayList<List>();
            for (List ancestors : ancestorNodeIds) {
                if (!ancestors.contains(startNodeWithNsu.getNodeId())) continue;
                ancestorsToRemove.add(ancestors);
                try {
                    List correspondingAbsPath = this.resolveCorrespondingAbsPath(ancestors, deletedNodeWithNsu, findNodeFn);
                    absPathsToRemove.add(correspondingAbsPath);
                }
                catch (AbsPathResolveException e) {
                    log.error("Cannot resolve corresponding absolute path to be removed, Reason: {}", (Object)e.getMessage());
                }
            }
            absPaths.removeAll(absPathsToRemove);
            ancestorNodeIds.removeAll(ancestorsToRemove);
            updateNodeFn.accept(deletedNodeWithNsu);
            log.debug("Updated paths for node {}, absolute paths: {}, ancestor nodes: {}", new Object[]{deletedNodeWithNsu.getNodeId(), deletedNodeWithNsu.getAbsolutePaths(), deletedNodeWithNsu.getAncestorNodeIds()});
        }
    }

    private List<String> resolveCorrespondingAbsPath(List<String> ancestorNodeIds, Node currentNode, Function<String, Optional<Node>> findNodeFn) throws AbsPathResolveException {
        ArrayList<String> absPath = new ArrayList<String>();
        for (String nodeId : ancestorNodeIds) {
            Optional<Node> ancestorNode = findNodeFn.apply(nodeId);
            if (ancestorNode.isPresent()) {
                absPath.add(ancestorNode.get().getBrowseName());
                continue;
            }
            throw new AbsPathResolveException("Cannot find ancestor node's browse name" + nodeId);
        }
        absPath.add(currentNode.getBrowseName());
        return absPath;
    }
}

