/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.addressspace.service.synchronizer;

import c8y.ua.Node;
import com.cumulocity.opcua.client.gateway.addressspace.service.synchronizer.AddressSpaceDataStoreSynchronizer;
import com.cumulocity.opcua.client.gateway.addressspace.service.synchronizer.IterativeDataStoreSynchronizer;
import com.cumulocity.opcua.client.gateway.addressspace.service.synchronizer.Synchronizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterativeDataStoreSynchronizer
extends Synchronizer
implements AddressSpaceDataStoreSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(IterativeDataStoreSynchronizer.class);

    public List<Node> syncAddressSpace(List<Node> localAddressSpaceNodes, List<Node> scannedAddressSpaceNodes, Node startNodeWithNsu) {
        LocalAddressSpace localAddressSpace = new LocalAddressSpace(this);
        localAddressSpace.setupDataStoreNodesToMap(localAddressSpaceNodes, startNodeWithNsu);
        Map localAddressSpaceMap = localAddressSpace.getLocalAddressSpaceMap();
        this.removeParentChildRefIfStartNodeParentChanged(localAddressSpaceMap, startNodeWithNsu);
        this.mergeAndUpdateScannedNodesAndAddressSpace(localAddressSpaceMap, scannedAddressSpaceNodes, startNodeWithNsu);
        this.updateAddressSpaceForDeletedNodes(localAddressSpace, scannedAddressSpaceNodes, startNodeWithNsu);
        return new ArrayList<Node>(localAddressSpaceMap.values());
    }

    private void removeParentChildRefIfStartNodeParentChanged(Map<String, Node> localAddressSpaceMap, Node startNodeWithNsu) {
        Node startNodeFromLocal = localAddressSpaceMap.get(startNodeWithNsu.getNodeId());
        if (Objects.nonNull(startNodeFromLocal)) {
            Set localStartNodeAncestorPaths = startNodeFromLocal.getAncestorNodeIds();
            Set scannedStartNodeAncestorPaths = startNodeWithNsu.getAncestorNodeIds();
            super.removeParentChildRefIfStartNodeParentChanged(startNodeWithNsu, localStartNodeAncestorPaths, scannedStartNodeAncestorPaths, nodeIdToSeach -> Optional.ofNullable((Node)localAddressSpaceMap.get(nodeIdToSeach)), nodeToUpdate -> localAddressSpaceMap.put(nodeToUpdate.getNodeId(), (Node)nodeToUpdate));
        }
    }

    private void mergeAndUpdateScannedNodesAndAddressSpace(Map<String, Node> localAddressSpaceMap, List<Node> scannedAddressSpaceNodes, Node startNodeWithNsu) {
        HashSet localStartNodePaths = new HashSet();
        if (Objects.nonNull(localAddressSpaceMap.get(startNodeWithNsu.getNodeId()))) {
            localStartNodePaths.addAll(localAddressSpaceMap.get(startNodeWithNsu.getNodeId()).getAbsolutePaths());
        }
        for (Node scannedNode : scannedAddressSpaceNodes) {
            String scannedNodeId = scannedNode.getNodeId();
            Node localNode = localAddressSpaceMap.get(scannedNodeId);
            if (Objects.nonNull(localNode)) {
                Set mergedItems;
                Set localNodeAbsPaths = localNode.getAbsolutePaths();
                Set localNodeAncestorNodeIds = localNode.getAncestorNodeIds();
                if (!localNodeAbsPaths.equals(scannedNode.getAbsolutePaths())) {
                    this.removeObsoleteAbsPath(localNodeAbsPaths, scannedNode.getAbsolutePaths(), localStartNodePaths, startNodeWithNsu.getAbsolutePaths());
                    mergedItems = this.mergeLists(localNodeAbsPaths, scannedNode.getAbsolutePaths());
                    scannedNode.setAbsolutePaths(mergedItems);
                    log.debug("Scanned node {} has additional absolute paths from local. Merged absolute paths: {}", (Object)scannedNodeId, (Object)scannedNode.getAbsolutePaths());
                }
                if (!localNodeAncestorNodeIds.equals(scannedNode.getAncestorNodeIds()) && !scannedNodeId.equals(startNodeWithNsu.getNodeId())) {
                    this.removeObsoleteAncestorPathUnderPartialTreeFromLocal(localNodeAncestorNodeIds, scannedNode.getAncestorNodeIds(), startNodeWithNsu.getNodeId());
                    mergedItems = this.mergeLists(localNodeAncestorNodeIds, scannedNode.getAncestorNodeIds());
                    scannedNode.setAncestorNodeIds(mergedItems);
                    log.debug("Scanned node {} has additional ancestor nodes from local. Merged ancestor nodes: {}", (Object)scannedNodeId, (Object)scannedNode.getAncestorNodeIds());
                }
            }
            localAddressSpaceMap.put(scannedNodeId, scannedNode);
        }
    }

    private void removeObsoleteAbsPath(Set<List<String>> localNodePaths, Set<List<String>> scannedNodePaths, Set<List<String>> localStartNodePaths, Set<List<String>> scannedStartNodePaths) {
        ArrayList<List<String>> pathsToRemove = new ArrayList<List<String>>();
        if (Objects.nonNull(scannedStartNodePaths) && !localStartNodePaths.isEmpty()) {
            if (!scannedStartNodePaths.equals(localStartNodePaths)) {
                for (List<String> localStartNodePath : localStartNodePaths) {
                    for (List<String> localNodePath : localNodePaths) {
                        List<String> localNodePathFirstItems = localNodePath.subList(0, localStartNodePath.size());
                        if (!localNodePathFirstItems.equals(localStartNodePath)) continue;
                        pathsToRemove.add(localNodePath);
                    }
                }
            } else {
                for (List<String> startNodePath : scannedStartNodePaths) {
                    for (List<String> localNodePath : localNodePaths) {
                        List<String> localNodePathFirstItems = localNodePath.subList(0, startNodePath.size());
                        if (!localNodePathFirstItems.equals(startNodePath) || scannedNodePaths.contains(localNodePath)) continue;
                        pathsToRemove.add(localNodePath);
                    }
                }
            }
        }
        if (pathsToRemove.size() > 0) {
            localNodePaths.removeAll(pathsToRemove);
        }
    }

    private void removeObsoleteAncestorPathUnderPartialTreeFromLocal(Set<List<String>> localNodePaths, Set<List<String>> scannedNodePaths, String startNodeIdWithUri) {
        ArrayList<List<String>> pathsToRemove = new ArrayList<List<String>>();
        for (List<String> localNodePath : localNodePaths) {
            if (!localNodePath.contains(startNodeIdWithUri) || scannedNodePaths.contains(localNodePath)) continue;
            pathsToRemove.add(localNodePath);
        }
        if (pathsToRemove.size() > 0) {
            localNodePaths.removeAll(pathsToRemove);
        }
    }

    private void updateAddressSpaceForDeletedNodes(LocalAddressSpace localAddressSpace, List<Node> scannedAddressSpaceNodes, Node startNodeWithNsu) {
        Map localAddressSpaceMap = localAddressSpace.getLocalAddressSpaceMap();
        Map deletedNodes = this.findDeletedNodes(localAddressSpace.getLocalPartialAddressSpaceMap(), scannedAddressSpaceNodes);
        for (Map.Entry deletedNode : deletedNodes.entrySet()) {
            Node deletedNodeFromLocal = (Node)localAddressSpaceMap.get(deletedNode.getKey());
            super.updateAddressSpaceForDeletedNode(startNodeWithNsu, deletedNodeFromLocal, nodeIdToFind -> Optional.ofNullable((Node)localAddressSpaceMap.get(nodeIdToFind)), nodeToUpdate -> localAddressSpaceMap.put(nodeToUpdate.getNodeId(), nodeToUpdate), nodeToDelete -> localAddressSpaceMap.remove(nodeToDelete));
        }
    }

    private Map<String, Node> findDeletedNodes(Map<String, Node> localPartialAddressSpaceMap, List<Node> scannedAddressSpaceNodes) {
        ConcurrentHashMap<String, Node> removedNodesMap = new ConcurrentHashMap<String, Node>();
        removedNodesMap.putAll(localPartialAddressSpaceMap);
        for (Node scannedNode : scannedAddressSpaceNodes) {
            removedNodesMap.remove(scannedNode.getNodeId());
        }
        return removedNodesMap;
    }

    private Set<List<String>> mergeLists(Set<List<String>> localNodePaths, Set<List<String>> scannedNodePaths) {
        HashSet<List<String>> mergedItems = new HashSet<List<String>>(scannedNodePaths);
        mergedItems.addAll(localNodePaths);
        return mergedItems;
    }
}

