/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.datastore.DataStore;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectCollectionRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.RestOperations;
import com.cumulocity.sdk.client.SDKException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AddressSpaceCleaner {
    private static final Logger log = LoggerFactory.getLogger(AddressSpaceCleaner.class);
    public static final String SCANNED_ADDRESS_SPACE_SERVERS = "scannedAddressSpaceServers";
    private final ConnectionManager connectionManager;
    private final InventoryRepository inventoryRepository;
    private final RestOperations restOperations;
    private final DataStore dbStore;
    private final DataStore addressSpaceDataStore;

    @Autowired
    public AddressSpaceCleaner(ConnectionManager connectionManager, InventoryRepository inventoryRepository, RestOperations restOperations, @Qualifier(value="gatewayDataStore") DataStore dbStore, @Qualifier(value="addressSpaceFileDataStore") DataStore addressSpaceDataStore) {
        this.connectionManager = connectionManager;
        this.inventoryRepository = inventoryRepository;
        this.restOperations = restOperations;
        this.dbStore = dbStore;
        this.addressSpaceDataStore = addressSpaceDataStore;
    }

    @Async
    synchronized void tryClean(Stream<ServerIdentifier> removedServersReported, String owner) {
        Collection currentServerIds = this.connectionManager.getAllServerIdentifiers().stream().map(identifier -> identifier.getInventoryIdentifier().getValue()).collect(Collectors.toSet());
        Collection serversThatHaveAddressSpaceScanned = this.getAllRecordAddressSpaceScanServers();
        Stream<String> removedServerIds = removedServersReported.map(identifier -> identifier.getInventoryIdentifier().getValue());
        Stream<String> missingServerIds = serversThatHaveAddressSpaceScanned.stream().filter(scannedServer -> !currentServerIds.contains(scannedServer)).filter(arg_0 -> this.isMONotExisted(arg_0));
        Collection missingAndRemoved = Stream.concat(removedServerIds, missingServerIds).collect(Collectors.toSet());
        for (String serverId : missingAndRemoved) {
            this.cleanForServer(serverId, owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanForServer(String serverId, String owner) {
        boolean hasMore = true;
        int total = 0;
        int totalFailed = 0;
        log.info("Deleting address space nodes for server: {}", (Object)serverId);
        String path = this.buildPath(owner, serverId);
        try {
            while (hasMore) {
                ManagedObjectCollectionRepresentation nodes = (ManagedObjectCollectionRepresentation)this.restOperations.get(path, MediaType.APPLICATION_JSON_TYPE, ManagedObjectCollectionRepresentation.class);
                int failedToDelete = 0;
                for (ManagedObjectRepresentation mo : nodes.getManagedObjects()) {
                    if (this.verifyMOToDelete(mo, owner, serverId)) {
                        try {
                            this.inventoryRepository.delete(mo.getId());
                        }
                        catch (Exception e) {
                            ++failedToDelete;
                            log.warn("Unable to delete MO: {}", (Object)mo.getId());
                        }
                        continue;
                    }
                    log.warn("Unexpected MO returned from Inventory API: {}", (Object)mo.getId().getValue());
                }
                total += nodes.getManagedObjects().size();
                totalFailed += failedToDelete;
                hasMore = nodes.getManagedObjects().size() != 0 && failedToDelete < nodes.getManagedObjects().size();
            }
        }
        catch (Exception e) {
            try {
                log.warn("Unable to fully clean address space for server: {}, reason: {}", (Object)serverId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                log.info("Finished deleting address space nodes for server: {}, {} managed objects deleted, {} were not deleted", new Object[]{serverId, total, totalFailed});
                this.markAddressSpaceNodesAsDeleted(serverId);
                this.removeAddressSpaceNodesFromDataStore(serverId);
                throw throwable;
            }
            log.info("Finished deleting address space nodes for server: {}, {} managed objects deleted, {} were not deleted", new Object[]{serverId, total, totalFailed});
            this.markAddressSpaceNodesAsDeleted(serverId);
            this.removeAddressSpaceNodesFromDataStore(serverId);
        }
        log.info("Finished deleting address space nodes for server: {}, {} managed objects deleted, {} were not deleted", new Object[]{serverId, total, totalFailed});
        this.markAddressSpaceNodesAsDeleted(serverId);
        this.removeAddressSpaceNodesFromDataStore(serverId);
    }

    public void recordAddressSpaceScan(String serverId) {
        try {
            Optional servers = this.dbStore.get(SCANNED_ADDRESS_SPACE_SERVERS);
            if (servers.isPresent()) {
                String[] serverArray = (String[])servers.get();
                HashSet<String> serverSet = new HashSet<String>(Arrays.asList(serverArray));
                serverSet.add(serverId);
                this.dbStore.store(SCANNED_ADDRESS_SPACE_SERVERS, (Serializable)serverSet.toArray(new String[0]));
            } else {
                this.dbStore.store(SCANNED_ADDRESS_SPACE_SERVERS, (Serializable)new String[]{serverId});
            }
        }
        catch (Exception e) {
            log.warn("Unable to record address space operation for server {}, if the server is removed, its address space nodes will not be removed", (Object)serverId, (Object)e);
        }
    }

    String buildPath(String owner, String serverId) {
        String query = String.format("$filter=type eq '%s'  and owner eq '%s' and '%s' eq '%s'", "c8y_OpcuaNode", owner, "c8y_OpcuaServerId", serverId);
        try {
            query = URLEncoder.encode(query, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return "/inventory/managedObjects?query=" + query + "&pageSize=100&currentPage=1";
    }

    private Collection<String> getAllRecordAddressSpaceScanServers() {
        Optional servers = this.dbStore.get(SCANNED_ADDRESS_SPACE_SERVERS);
        if (servers.isPresent()) {
            String[] serverArray = (String[])servers.get();
            return new HashSet<String>(Arrays.asList(serverArray));
        }
        return Collections.emptyList();
    }

    private void markAddressSpaceNodesAsDeleted(String serverId) {
        String[] serverArray;
        Set<String> updatedServers;
        Optional servers = this.dbStore.get(SCANNED_ADDRESS_SPACE_SERVERS);
        if (servers.isPresent() && (updatedServers = Stream.of(serverArray = (String[])servers.get()).filter(server -> !server.equals(serverId)).collect(Collectors.toSet())).size() < serverArray.length) {
            this.dbStore.store(SCANNED_ADDRESS_SPACE_SERVERS, (Serializable)updatedServers.toArray(new String[0]));
        }
    }

    private void removeAddressSpaceNodesFromDataStore(String serverId) {
        Optional removedAddressSpace = this.addressSpaceDataStore.remove(SCANNED_ADDRESS_SPACE_SERVERS, serverId);
        int removedItemsCount = 0;
        if (removedAddressSpace.isPresent()) {
            removedItemsCount = ((List)removedAddressSpace.get()).size();
        }
        log.info("Finished deleting address space from data store for server: {}, {} items deleted", (Object)serverId, (Object)removedItemsCount);
    }

    private boolean verifyMOToDelete(ManagedObjectRepresentation mo, String owner, String serverId) {
        return mo.getOwner().equals(owner) && mo.get("c8y_OpcuaServerId").equals(serverId) && mo.getType().equals("c8y_OpcuaNode");
    }

    private boolean isMONotExisted(String id) {
        try {
            ManagedObjectRepresentation serverMO = this.inventoryRepository.get(GId.asGId((String)id));
            return Objects.isNull(serverMO);
        }
        catch (SDKException e) {
            return e.getHttpStatus() == 404;
        }
    }
}

