/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription.repository;

import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItem;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItemId;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedNode;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.cumulocity.opcua.common.model.mapping.ExecutableMappingAction;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class LocalSubscriptionRepository
implements SubscriptionRepository {
    private ConcurrentHashMap<SubscribedItemId, SubscribedItem> subscribedItems = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Collection<SubscribedNode>> subscribedNodes = new ConcurrentHashMap();

    public Optional<UnsignedInteger> getServerSubscriptionId(String serverId) {
        for (SubscribedItem item : this.subscribedItems.values()) {
            if (!item.getServerId().equals(serverId) || !Objects.nonNull(item.getSubscriptionId())) continue;
            return Optional.ofNullable(item.getSubscriptionId());
        }
        return Optional.empty();
    }

    public void updateSubscriptionId(String serverId, UnsignedInteger oldSubscriptionId, UnsignedInteger updatedSubscriptionId) {
        this.subscribedItems.values().forEach(item -> {
            if (serverId.equals(item.getServerId()) && oldSubscriptionId.equals((Object)item.getSubscriptionId())) {
                item.setSubscriptionId(updatedSubscriptionId);
            }
        });
    }

    public void addSubscribedItems(Collection<SubscribedItem> items) {
        for (SubscribedItem item : items) {
            this.subscribedItems.put(item.getSubscribedItemId(), item);
            SubscribedNode subscribedNode = new SubscribedNode(item.getDeviceTypeId(), item.getRootNodeId(), item.getSubscriptionType());
            Collection serverSubscribedNodes = (Collection)this.subscribedNodes.get(item.getServerId());
            if (CollectionUtils.isEmpty((Collection)serverSubscribedNodes)) {
                this.subscribedNodes.put(item.getServerId(), Collections.synchronizedCollection(new HashSet<SubscribedNode>(Collections.singleton(subscribedNode))));
                continue;
            }
            serverSubscribedNodes.add(subscribedNode);
        }
    }

    public Optional<UnsignedInteger> removeServerSubscriptions(String serverId, String subscriptionType) {
        return this.removeIf(serverId, item -> item.getServerId().equals(serverId) && this.matchesItemType(subscriptionType).test(item), node -> this.matchesNodeType(subscriptionType).test(node)).stream().filter(item -> Objects.nonNull(item.getSubscriptionId())).map(SubscribedItem::getSubscriptionId).findAny();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<SubscribedNode> getAppliedNode(String serverId, String deviceTypeId, String rootNodeId) {
        Collection serverSubscribedNodes = (Collection)this.subscribedNodes.get(serverId);
        if (!CollectionUtils.isEmpty((Collection)serverSubscribedNodes)) {
            Collection collection = serverSubscribedNodes;
            synchronized (collection) {
                return serverSubscribedNodes.stream().filter(subscribedNode -> subscribedNode.getDeviceTypeId().equalsIgnoreCase(deviceTypeId) && subscribedNode.getRootNodeId().equalsIgnoreCase(rootNodeId)).findFirst();
            }
        }
        return Optional.empty();
    }

    public Collection<SubscribedNode> getSubscribedNodes(String serverId) {
        Collection subscribedNodes = (Collection)this.subscribedNodes.get(serverId);
        if (CollectionUtils.isEmpty((Collection)subscribedNodes)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(new HashSet(subscribedNodes));
    }

    public Collection<SubscribedItem> removeSubscribedNode(String serverId, String deviceTypeId, String rootNodeId, String subscriptionType) {
        return this.removeIf(serverId, item -> item.getDeviceTypeId().equals(deviceTypeId) && item.getRootNodeId().equals(rootNodeId) && item.getSubscribedItemId().getServerId().equals(serverId) && this.matchesItemType(subscriptionType).test(item), node -> node.getDeviceTypeId().equals(deviceTypeId) && node.getRootNodeId().equals(rootNodeId) && this.matchesNodeType(subscriptionType).test(node));
    }

    public Collection<SubscribedItem> removeSubscribedItemsForDeviceTypes(String serverId, Collection<String> deviceTypeIds, String subscriptionType) {
        return this.removeIf(serverId, item -> deviceTypeIds.contains(item.getDeviceTypeId()) && item.getServerId().equals(serverId) && this.matchesItemType(subscriptionType).test(item), node -> deviceTypeIds.contains(node.getDeviceTypeId()) && this.matchesNodeType(subscriptionType).test(node));
    }

    public Collection<ExecutableMappingAction> getMappedActions(String serverId, String targetNodeId, UnsignedInteger monitoredItemId) {
        SubscribedItemId item = new SubscribedItemId(serverId, targetNodeId, monitoredItemId);
        SubscribedItem subscribedItem = (SubscribedItem)this.subscribedItems.get(item);
        if (Objects.nonNull(subscribedItem)) {
            return subscribedItem.getMappedActions();
        }
        return Collections.emptySet();
    }

    public Optional<SubscribedItem> getSubscribedItem(String serverId, String targetNodeId, UnsignedInteger monitoredItemId) {
        SubscribedItemId item = new SubscribedItemId(serverId, targetNodeId, monitoredItemId);
        return Optional.ofNullable((SubscribedItem)this.subscribedItems.get(item));
    }

    public Collection<ExecutableMappingAction> getMappedActions(String serverId, String targetNodeId) {
        HashSet<ExecutableMappingAction> result = new HashSet<ExecutableMappingAction>();
        for (SubscribedItem item : this.subscribedItems.values()) {
            if (!item.getServerId().equals(serverId) || !item.getTargetNodeId().equals(targetNodeId)) continue;
            result.addAll(item.getMappedActions());
        }
        return result;
    }

    public Collection<ExecutableMappingAction> getMappedActions(String serverId, String targetNodeId, String deviceTypeId, String rootNodeId) {
        HashSet<ExecutableMappingAction> result = new HashSet<ExecutableMappingAction>();
        for (SubscribedItem item : this.subscribedItems.values()) {
            if (!item.getServerId().equals(serverId) || !item.getTargetNodeId().equals(targetNodeId) || !deviceTypeId.equals(item.getDeviceTypeId()) || !rootNodeId.equals(item.getRootNodeId())) continue;
            result.addAll(item.getMappedActions());
        }
        return result;
    }

    private Predicate<SubscribedItem> matchesItemType(String subscriptionType) {
        return item -> Objects.isNull(subscriptionType) || item.getSubscriptionType().equalsIgnoreCase(subscriptionType);
    }

    private Predicate<SubscribedNode> matchesNodeType(String subscriptionType) {
        return node -> Objects.isNull(subscriptionType) || node.getSubscriptionType().equalsIgnoreCase(subscriptionType);
    }

    private Collection<SubscribedItem> removeIf(String serverId, Predicate<SubscribedItem> predicate, Predicate<SubscribedNode> subscribedNodePredicate) {
        HashSet<SubscribedItem> result = new HashSet<SubscribedItem>();
        Iterator valuesIt = this.subscribedItems.values().iterator();
        while (valuesIt.hasNext()) {
            SubscribedItem item = (SubscribedItem)valuesIt.next();
            if (!predicate.test(item) || !item.getServerId().equals(serverId)) continue;
            result.add(item);
            valuesIt.remove();
        }
        Collection serverSubscribedNodes = (Collection)this.subscribedNodes.get(serverId);
        if (!CollectionUtils.isEmpty((Collection)serverSubscribedNodes)) {
            serverSubscribedNodes.removeIf(subscribedNodePredicate);
        }
        return result;
    }
}

