/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription.model;

import com.cumulocity.opcua.client.gateway.mappings.model.DataMappingParameters;
import com.cumulocity.opcua.client.gateway.subscription.model.BaseSubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class SubscriptionData
extends BaseSubscriptionData {
    private Map<String, DataMappingParameters> nodeSubscriptions;

    public SubscriptionData(String serverId, String deviceTypeId, String rootNodeId, Map<String, DataMappingParameters> nodeSubscriptions) {
        super(serverId, deviceTypeId, rootNodeId);
        this.nodeSubscriptions = nodeSubscriptions;
    }

    public void putNodeSubscription(String nodeId, DataMappingParameters mappingParameters) {
        if (Objects.isNull(this.nodeSubscriptions)) {
            this.nodeSubscriptions = new HashMap();
        }
        this.nodeSubscriptions.put(nodeId, mappingParameters);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty((Map)this.nodeSubscriptions);
    }

    public static SubscriptionDataBuilder builder() {
        return new SubscriptionDataBuilder();
    }

    public SubscriptionData() {
    }

    public String toString() {
        return "SubscriptionData(nodeSubscriptions=" + String.valueOf(this.getNodeSubscriptions()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionData)) {
            return false;
        }
        SubscriptionData other = (SubscriptionData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map this$nodeSubscriptions = this.getNodeSubscriptions();
        Map other$nodeSubscriptions = other.getNodeSubscriptions();
        return !(this$nodeSubscriptions == null ? other$nodeSubscriptions != null : !((Object)this$nodeSubscriptions).equals(other$nodeSubscriptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map $nodeSubscriptions = this.getNodeSubscriptions();
        result = result * 59 + ($nodeSubscriptions == null ? 43 : ((Object)$nodeSubscriptions).hashCode());
        return result;
    }

    public Map<String, DataMappingParameters> getNodeSubscriptions() {
        return this.nodeSubscriptions;
    }

    public void setNodeSubscriptions(Map<String, DataMappingParameters> nodeSubscriptions) {
        this.nodeSubscriptions = nodeSubscriptions;
    }
}

