/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription;

import c8y.IsDevice;
import c8y.ua.data.BrowsePathSubscription;
import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.MappedTargetNode;
import c8y.ua.data.SubscriptionType;
import com.cumulocity.model.ID;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.connection.model.DeviceCreatedEvent;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.model.DataMappingParameters;
import com.cumulocity.opcua.client.gateway.mappings.model.EventMappingParameters;
import com.cumulocity.opcua.client.gateway.platform.repository.IdentityRepository;
import com.cumulocity.opcua.client.gateway.subscription.model.NodeEventTypeId;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionEventData;
import com.cumulocity.opcua.common.IdentityUtils;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.cumulocity.opcua.common.model.mapping.DeviceTypeMappingEntry;
import com.cumulocity.opcua.common.model.mapping.ExecutableMappingAction;
import com.cumulocity.opcua.common.model.mapping.UaEventMapping;
import com.cumulocity.opcua.common.model.mapping.action.C8YMappingAction;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.ProcessingMode;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubscriptionDataResolver {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionDataResolver.class);
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private IdentityRepository identityRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private InventoryRepository inventoryRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Optional<SubscriptionData>, Optional<SubscriptionEventData>> resolve(String serverId, DeviceType deviceType, DeviceTypeMappedNode mappedNode) throws ServerNotConnectedException {
        String rootNodeId = mappedNode.getNodeId();
        log.info("Resolving subscription data for node: {} and device type: {}", (Object)rootNodeId, (Object)deviceType.getId());
        Optional clientOptional = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)serverId)));
        if (!clientOptional.isPresent()) {
            throw new ServerNotConnectedException("Server not connected: " + serverId);
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        try {
            log.info("Resolving data for {} target nodes", (Object)mappedNode.getMappedTargetNodes().size());
            Pair pair = Pair.of((Object)this.resolveData(client, serverId, deviceType, mappedNode), (Object)this.resolveEvents(client, serverId, deviceType, mappedNode));
            return pair;
        }
        finally {
            log.info("Resolved subscription data for node: {} and device type: {}", (Object)rootNodeId, (Object)deviceType.getId());
        }
    }

    private Optional<SubscriptionData> resolveData(OpcuaClient client, String serverId, DeviceType deviceType, DeviceTypeMappedNode mappedNode) {
        if (CollectionUtils.isEmpty((Collection)deviceType.getMappings()) || CollectionUtils.isEmpty((Collection)mappedNode.getMappedTargetNodes())) {
            return Optional.empty();
        }
        SubscriptionData subscriptionData = SubscriptionData.builder().deviceTypeId(deviceType.getId()).serverId(serverId).rootNodeId(NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)mappedNode.getNodeId())).build();
        Map mappingsAsMap = deviceType.mappingsAsMap();
        for (MappedTargetNode targetNode : mappedNode.getMappedTargetNodes()) {
            DeviceTypeMappingEntry mappingEntry = (DeviceTypeMappingEntry)mappingsAsMap.get(targetNode.getMappingBrowsePath());
            if (Objects.isNull(mappingEntry)) {
                mappingEntry = (DeviceTypeMappingEntry)mappingsAsMap.get(NodeIds.toBrowsePath((NamespaceTable)client.getNamespaceTable(), (List)targetNode.getMappingBrowsePath()));
            }
            if (!Objects.nonNull(mappingEntry)) continue;
            SubscriptionType subscriptionType = this.decideSubscriptionType(deviceType, targetNode.getMappingBrowsePath(), client.getNamespaceTable());
            if (subscriptionType.isValid()) {
                subscriptionData.putNodeSubscription(NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)targetNode.getTargetNodeId()), new DataMappingParameters(subscriptionType, this.getMappedActions(client.getNamespaceTable(), serverId, deviceType, mappedNode.getNodeId(), mappingEntry)));
                continue;
            }
            log.info("Subscription type is not valid, deviceType: {}, serverId: {}, skip adding to subscription: {}", new Object[]{deviceType.getId(), serverId, subscriptionType});
        }
        return Optional.of(subscriptionData);
    }

    private Optional<SubscriptionEventData> resolveEvents(OpcuaClient client, String serverId, DeviceType deviceType, DeviceTypeMappedNode mappedNode) {
        if (CollectionUtils.isEmpty((Collection)deviceType.getUaEventMappings())) {
            return Optional.empty();
        }
        SubscriptionEventData eventData = SubscriptionEventData.builder().deviceTypeId(deviceType.getId()).rootNodeId(NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)mappedNode.getNodeId())).serverId(serverId).build();
        Map mappingsAsMap = deviceType.uaEventMappingsAsMap();
        for (MappedTargetNode targetNode : mappedNode.getMappedTargetNodes()) {
            UaEventMapping mappingEntry = (UaEventMapping)mappingsAsMap.get(targetNode.getMappingBrowsePath());
            if (Objects.isNull(mappingEntry)) {
                mappingEntry = (UaEventMapping)mappingsAsMap.get(NodeIds.toBrowsePath((NamespaceTable)client.getNamespaceTable(), (List)targetNode.getMappingBrowsePath()));
            }
            if (!Objects.nonNull(mappingEntry)) continue;
            Collection mappingActions = this.getMappedActions(client.getNamespaceTable(), serverId, deviceType, mappedNode.getNodeId(), mappingEntry);
            String eventTypeId = NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)mappingEntry.getEventTypeId());
            List attributes = mappingEntry.getAttributes().stream().map(browsePath -> NodeIds.toBrowsePath((NamespaceTable)client.getNamespaceTable(), (String)browsePath)).collect(Collectors.toList());
            eventData.putEventSubscription(new NodeEventTypeId(NodeIds.toNodeId((NamespaceTable)client.getNamespaceTable(), (String)targetNode.getTargetNodeId()), eventTypeId), new EventMappingParameters(mappingActions, attributes));
        }
        return Optional.of(eventData);
    }

    private SubscriptionType decideSubscriptionType(DeviceType deviceType, List<String> browsePath, NamespaceTable namespaceTable) {
        Optional<BrowsePathSubscription> matchingBrowsePath;
        SubscriptionType subscriptionType = deviceType.getSubscriptionType();
        if (!CollectionUtils.isEmpty((Collection)deviceType.getOverriddenSubscriptions()) && (matchingBrowsePath = deviceType.getOverriddenSubscriptions().stream().filter(subscription -> NodeIds.browsePathsEqual((NamespaceTable)namespaceTable, (List)subscription.getBrowsePath(), (List)browsePath)).findFirst()).isPresent()) {
            subscriptionType = matchingBrowsePath.get().getSubscriptionType();
        }
        return subscriptionType;
    }

    private Collection<ExecutableMappingAction> getMappedActions(NamespaceTable namespaceTable, String serverId, DeviceType deviceType, String rootNodeId, DeviceTypeMappingEntry mappingEntry) {
        String rootNodeWithNsUri = NodeIds.toNodeIdWithNsUri((NamespaceTable)namespaceTable, (String)rootNodeId);
        GId sourceDeviceId = this.getOrCreateSourceDevice(serverId, deviceType, rootNodeWithNsUri);
        ArrayList<ExecutableMappingAction> actions = new ArrayList<ExecutableMappingAction>();
        if (Objects.nonNull(mappingEntry.getCustomAction())) {
            actions.add(new ExecutableMappingAction(sourceDeviceId, (MappingAction)mappingEntry.getCustomAction()));
        }
        if (Objects.nonNull(mappingEntry.getEventCreation())) {
            actions.add(this.createC8YMappingAction(sourceDeviceId, deviceType, (C8YMappingAction)mappingEntry.getEventCreation()));
        }
        if (Objects.nonNull(mappingEntry.getAlarmCreation())) {
            actions.add(this.createC8YMappingAction(sourceDeviceId, deviceType, (C8YMappingAction)mappingEntry.getAlarmCreation()));
        }
        if (Objects.nonNull(mappingEntry.getMeasurementCreation())) {
            actions.add(this.createC8YMappingAction(sourceDeviceId, deviceType, (C8YMappingAction)mappingEntry.getMeasurementCreation()));
        }
        return actions;
    }

    ExecutableMappingAction createC8YMappingAction(GId sourceDeviceId, DeviceType deviceType, C8YMappingAction c8yMappingAction) {
        Optional processingModeOptional = this.resolveProcessingMode(deviceType, c8yMappingAction);
        if (processingModeOptional.isPresent()) {
            ProcessingMode processingMode = (ProcessingMode)processingModeOptional.get();
            if (c8yMappingAction.getSupportedProcessingModes().contains(processingMode)) {
                return new ExecutableMappingAction(sourceDeviceId, (MappingAction)c8yMappingAction, processingMode);
            }
            log.warn("{} mapping action for device type: {} does not support given processing mode {}. The mapping will be executed in default mode", new Object[]{c8yMappingAction.getMappingActionName(), deviceType.getId(), processingMode.name()});
        }
        return new ExecutableMappingAction(sourceDeviceId, (MappingAction)c8yMappingAction);
    }

    Optional<ProcessingMode> resolveProcessingMode(DeviceType deviceType, C8YMappingAction c8yMappingAction) {
        ProcessingMode processingMode = deviceType.getProcessingMode();
        ProcessingMode overriddenProcessingMode = c8yMappingAction.getOverriddenProcessingMode();
        if (!Objects.isNull(overriddenProcessingMode)) {
            return Optional.of(overriddenProcessingMode);
        }
        return Optional.ofNullable(processingMode);
    }

    private Collection<ExecutableMappingAction> getMappedActions(NamespaceTable namespaceTable, String serverId, DeviceType deviceType, String rootNodeId, UaEventMapping eventMapping) {
        String rootNodeWithNsUri = NodeIds.toNodeIdWithNsUri((NamespaceTable)namespaceTable, (String)rootNodeId);
        GId sourceDeviceId = this.getOrCreateSourceDevice(serverId, deviceType, rootNodeWithNsUri);
        ArrayList<ExecutableMappingAction> actions = new ArrayList<ExecutableMappingAction>();
        if (Objects.nonNull(eventMapping.getEventCreation())) {
            actions.add(new ExecutableMappingAction(sourceDeviceId, (MappingAction)eventMapping.getEventCreation()));
        }
        if (Objects.nonNull(eventMapping.getAlarmCreation())) {
            actions.add(new ExecutableMappingAction(sourceDeviceId, (MappingAction)eventMapping.getAlarmCreation()));
        }
        return actions;
    }

    private GId getOrCreateSourceDevice(String serverId, DeviceType deviceType, String rootNodeId) {
        ID identity = IdentityUtils.buildDeviceExternalId((String)serverId, (String)deviceType.getId(), (String)rootNodeId);
        Optional existingId = this.identityRepository.get(identity);
        if (existingId.isPresent()) {
            log.debug("Device for node: {} and device type: {} already exists. Device ID: {}", new Object[]{rootNodeId, deviceType.getId(), ((ExternalIDRepresentation)existingId.get()).getManagedObject().getId().getValue()});
            return ((ExternalIDRepresentation)existingId.get()).getManagedObject().getId();
        }
        ManagedObjectRepresentation sourceDevice = new ManagedObjectRepresentation();
        sourceDevice.setType("c8y_OpcuaDevice");
        sourceDevice.set((Object)serverId, "c8y_OpcuaServerId");
        sourceDevice.set((Object)new IsDevice());
        String deviceName = String.format("%s (%s)", deviceType.getName(), rootNodeId);
        sourceDevice.setName(deviceName);
        ManagedObjectRepresentation createdSourceDevice = this.inventoryRepository.create(sourceDevice);
        this.identityRepository.create(identity, createdSourceDevice.getId());
        this.inventoryRepository.referenceChildDevice(GId.asGId((String)serverId), createdSourceDevice.getId());
        log.info("Created new device for node: {} and device type: {}. Created device ID: {}", new Object[]{rootNodeId, deviceType.getId(), createdSourceDevice.getId().getValue()});
        DeviceCreatedEvent deviceCreatedEvent = new DeviceCreatedEvent(createdSourceDevice.getId().getValue());
        this.eventPublisher.publishEvent((Object)deviceCreatedEvent);
        return createdSourceDevice.getId();
    }
}

