/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription;

import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeRepository;
import com.cumulocity.opcua.client.gateway.subscription.DeviceTypeConverter;
import com.cumulocity.opcua.client.gateway.subscription.model.DeviceTypeFetchedItems;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceTypeFetcherService {
    private static final Logger log = LoggerFactory.getLogger(DeviceTypeFetcherService.class);
    @Autowired
    private DeviceTypeRepository deviceTypeRepository;
    private DateTime lastCheckTimeForUpdates;
    private Integer lastCheckAllDeviceTypeCount;
    private boolean initialCheckForUpdates = true;

    public synchronized DeviceTypeFetchedItems getDeviceTypesToApply(boolean withAllDeviceTypes) {
        DeviceTypeFetchedItems applyItems;
        DateTime currentCheckTimeForUpdates = DateTime.now();
        if (this.initialCheckForUpdates) {
            this.lastCheckTimeForUpdates = currentCheckTimeForUpdates;
            this.lastCheckAllDeviceTypeCount = this.deviceTypeRepository.getAllDeviceTypeCount();
            withAllDeviceTypes = true;
            this.initialCheckForUpdates = false;
        }
        if (withAllDeviceTypes) {
            applyItems = this.getAllDeviceTypesToApply();
        } else {
            int currentAllDeviceTypeCount = this.deviceTypeRepository.getAllDeviceTypeCount();
            List lastUpdatedDeviceTypes = this.deviceTypeRepository.getDeviceTypeMOsUpdatedAfter(this.lastCheckTimeForUpdates);
            if (lastUpdatedDeviceTypes.isEmpty()) {
                log.debug("No new or updated device type(s) detected after {}", (Object)this.lastCheckTimeForUpdates);
            } else {
                log.info("Detected {} new or updated device type(s) after {}", (Object)lastUpdatedDeviceTypes.size(), (Object)this.lastCheckTimeForUpdates);
            }
            int newItemCount = this.getNewItemCount(lastUpdatedDeviceTypes);
            if (currentAllDeviceTypeCount < this.lastCheckAllDeviceTypeCount + newItemCount) {
                log.info("Detected deletion of {} device type(s). Fetching all device types to update.", (Object)(this.lastCheckAllDeviceTypeCount + newItemCount - currentAllDeviceTypeCount));
                applyItems = this.getAllDeviceTypesToApply();
                applyItems.setDeletionDetected(true);
            } else {
                applyItems = this.getLastUpdatedDeviceTypesToApply(lastUpdatedDeviceTypes);
            }
            this.lastCheckAllDeviceTypeCount = currentAllDeviceTypeCount;
            this.lastCheckTimeForUpdates = currentCheckTimeForUpdates;
        }
        return applyItems;
    }

    private DeviceTypeFetchedItems getAllDeviceTypesToApply() {
        Map deviceTypes = this.deviceTypeRepository.getAllDeviceTypes();
        return new DeviceTypeFetchedItems(deviceTypes, true);
    }

    private DeviceTypeFetchedItems getLastUpdatedDeviceTypesToApply(List<ManagedObjectRepresentation> deviceTypesMOs) {
        if (deviceTypesMOs.isEmpty()) {
            return DeviceTypeFetchedItems.empty();
        }
        Map deviceTypes = DeviceTypeConverter.toDeviceTypeMap(deviceTypesMOs);
        return new DeviceTypeFetchedItems(deviceTypes, false);
    }

    private int getNewItemCount(List<ManagedObjectRepresentation> deviceTypeMOs) {
        int newItemCount = 0;
        for (ManagedObjectRepresentation deviceTypeMO : deviceTypeMOs) {
            if (!deviceTypeMO.getCreationDateTime().isAfter((ReadableInstant)this.lastCheckTimeForUpdates)) continue;
            ++newItemCount;
        }
        return newItemCount;
    }
}

