/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository.util;

import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.util.ElementQueueOperation;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleElementQueueOperation<T extends AbstractExtensibleRepresentation>
implements ElementQueueOperation<T, T> {
    private static final Logger log = LoggerFactory.getLogger(SingleElementQueueOperation.class);
    BaseQueuedRepository<T, T> baseQueuedRepository;

    public SingleElementQueueOperation(BaseQueuedRepository<T, T> baseQueuedRepository) {
        this.baseQueuedRepository = baseQueuedRepository;
    }

    public void addToQueue(ConcurrentLinkedQueue<T> queue, T element) {
        queue.add(element);
    }

    public void addToQueueWithSourceCheck(ConcurrentLinkedQueue<T> queue, T element) {
        if (this.baseQueuedRepository.getInventoryPresence().isKnownMissingSource(this.baseQueuedRepository.getElementSource(element))) {
            log.warn("Element {} is not added to the queue because its source is removed", element);
            return;
        }
        this.addToQueue(queue, element);
    }

    public void addToQueueWithSourceAvailability(ConcurrentLinkedQueue<T> queue, T element) {
        if (this.baseQueuedRepository.getInventoryPresence().checkSourceAvailability(this.baseQueuedRepository.getElementSource(element))) {
            log.info(this.baseQueuedRepository.getName() + ": Element source {} seems valid, re-adding to queue", (Object)this.baseQueuedRepository.getElementSource(element).getValue());
            this.addToQueueWithSourceCheck(queue, element);
        } else {
            log.info(this.baseQueuedRepository.getName() + ": Element source {} is invalid, disregarding element", (Object)this.baseQueuedRepository.getElementSource(element).getValue());
        }
    }

    public T getFromQueue(ConcurrentLinkedQueue<T> queue) {
        return (T)((AbstractExtensibleRepresentation)queue.poll());
    }
}

