/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import c8y.ua.data.DeviceTypeMappedNodeCollection;
import net.openhft.chronicle.map.ChronicleMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class MappedNodesRepository {
    private static final Logger log = LoggerFactory.getLogger(MappedNodesRepository.class);
    @Autowired
    @Qualifier(value="deviceTypeMappingStore")
    public ChronicleMap<String, DeviceTypeMappedNodeCollection> deviceTypeMappingStore;

    public DeviceTypeMappedNodeCollection get(String serverId) {
        return (DeviceTypeMappedNodeCollection)this.deviceTypeMappingStore.get((Object)serverId);
    }

    public void update(String serverId, DeviceTypeMappedNodeCollection deviceTypeMappedNodeCollection) {
        this.create(serverId, deviceTypeMappedNodeCollection);
    }

    public void create(String serverId, DeviceTypeMappedNodeCollection deviceTypeMappedNodeCollection) {
        this.deviceTypeMappingStore.put((Object)serverId, (Object)deviceTypeMappedNodeCollection);
    }

    public void delete(String serverId) {
        this.deviceTypeMappingStore.remove((Object)serverId);
    }

    @Autowired
    public MappedNodesRepository() {
    }

    public void setDeviceTypeMappingStore(ChronicleMap<String, DeviceTypeMappedNodeCollection> deviceTypeMappingStore) {
        this.deviceTypeMappingStore = deviceTypeMappingStore;
    }
}

