/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler.base;

import c8y.Command;
import c8y.ua.command.BaseHistoricReadOperation;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.model.HistoricReadResult;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.encoding.EncodingException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class BaseHistoricOperationHandler<T extends BaseHistoricReadOperation>
extends UAOperationHandler<T> {
    public BaseHistoricOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, Class<T> supportedOperationType, DeviceControlApi deviceControlApi, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, supportedOperationType, deviceControlApi, inventoryApi, nodeValidator);
    }

    protected abstract int getDefaultBatchSize();

    protected abstract int processData(HistoricReadResult var1, T var2, int var3) throws IOException, EncodingException;

    protected abstract Command onCompleted(int var1, Supplier<Object> var2);

    protected HandleInternalResult handleInternal(T operation) throws OperationExecutionException {
        Optional clientOptional = this.resolveClient(operation);
        if (!clientOptional.isPresent()) {
            throw new OperationExecutionException("UA Server is not resolvable / not connected!");
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        int batches = 0;
        int accumulatedResult = 0;
        try {
            HistoricReadResult historicReadResult = new HistoricReadResult();
            do {
                historicReadResult = client.historyRead(operation.getDateTimeFrom(), operation.getDateTimeTo(), operation.getNodeId(), operation.getRanges(), this.getBatchSize(operation), historicReadResult.getContinuationPoint());
                int result = this.processData(historicReadResult, operation, batches);
                ++batches;
                accumulatedResult += result;
            } while (historicReadResult.getContinuationPoint().isPresent());
            HandleInternalResult internalResult = new HandleInternalResult();
            internalResult.setSuccessful(true);
            int finalAccumulatedResult = accumulatedResult;
            internalResult.setCommand(this.onCompleted(batches, () -> finalAccumulatedResult));
            return internalResult;
        }
        catch (OpcuaClientException | EncodingException | IOException e) {
            throw new OperationExecutionException(e);
        }
    }

    private int getBatchSize(T operation) {
        return Objects.isNull(operation.getBatchSize()) ? this.getDefaultBatchSize() : operation.getBatchSize().intValue();
    }
}

