/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.ua.Node;
import c8y.ua.command.BaseOperation;
import c8y.ua.command.ScanAddressSpace;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.AddressSpaceCleaner;
import com.cumulocity.opcua.client.gateway.AddressSpaceScanner;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.addressspace.exception.AddressSpaceInventorySyncException;
import com.cumulocity.opcua.client.gateway.addressspace.service.AddressSpaceInventoryService;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.connection.model.AddressSpaceUpdatedEvent;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAServerOperationHandler;
import com.cumulocity.opcua.common.repository.AddressSpaceRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScanAddressSpaceHandler
extends UAServerOperationHandler<ScanAddressSpace> {
    private static final Logger log = LoggerFactory.getLogger(ScanAddressSpaceHandler.class);
    private final AddressSpaceRepository addressSpaceRepository;
    private final AddressSpaceInventoryService addressSpaceInventoryService;
    private final AddressSpaceCleaner addressSpaceCleaner;
    private final AddressSpaceScanner addressSpaceScanner;
    private final ApplicationEventPublisher eventPublisher;
    private final int operationTimeoutInMinutes;

    @Autowired
    public ScanAddressSpaceHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, AddressSpaceRepository addressSpaceRepository, AddressSpaceInventoryService addressSpaceInventoryService, AddressSpaceCleaner addressSpaceCleaner, AddressSpaceScanner addressSpaceScanner, ApplicationEventPublisher eventPublisher, @Value(value="${gateway.scanAddressSpace.timeout:1440}") int operationTimeoutInMinutes) {
        super(gatewayManager, connectionManager, ScanAddressSpace.class, deviceControlApi);
        this.addressSpaceRepository = addressSpaceRepository;
        this.addressSpaceInventoryService = addressSpaceInventoryService;
        this.addressSpaceCleaner = addressSpaceCleaner;
        this.addressSpaceScanner = addressSpaceScanner;
        this.eventPublisher = eventPublisher;
        this.operationTimeoutInMinutes = operationTimeoutInMinutes;
    }

    protected HandleInternalResult handleInternal(ScanAddressSpace operation) throws OperationExecutionException {
        Optional clientOptional = this.resolveClient((BaseOperation)operation);
        if (!clientOptional.isPresent()) {
            log.error("Cannot execute operation {}, because gateway is not connected to server or operation was send to non-OPC Server object.", (Object)operation.getOperationId());
            HandleInternalResult notConnectedResult = new HandleInternalResult();
            notConnectedResult.setFailureReason("Gateway is not connected to OPC UA server or operation was send to non-OPC Server object.");
            notConnectedResult.setSuccessful(false);
            return notConnectedResult;
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        GId serverId = operation.getDeviceId();
        try {
            NamespaceTable namespaceTable = client.getNamespaceTable();
            Node startNode = new Node();
            this.addressSpaceCleaner.recordAddressSpaceScan(operation.getDeviceId().getValue());
            if (StringUtils.isEmpty((String)operation.getNodeId())) {
                operation.setNodeId(Identifiers.RootFolder.toString());
            }
            startNode.setNodeId(operation.getNodeId());
            if (NodeIds.isRootFolderNodeId((String)operation.getNodeId())) {
                log.info("Starting full address space scan for server with managed object id {}", (Object)operation.getDeviceId());
            } else {
                log.info("Starting address space scan from start node {} for server with managed object id {}", (Object)operation.getNodeId(), (Object)operation.getDeviceId());
                Optional rootNodeMoOptional = this.addressSpaceRepository.findNodeMo(namespaceTable, operation.getDeviceId().getValue(), Identifiers.RootFolder.toString());
                if (rootNodeMoOptional.isPresent() && !this.isRootLevelAncestorFragmentPresent((ManagedObjectRepresentation)rootNodeMoOptional.get())) {
                    return this.failScanForLegacyStructure();
                }
                if (!client.doesNodeExist(operation.getNodeId())) {
                    return this.failScanWithReason("Cannot start partial scan with node " + operation.getNodeId() + " because node does not exist");
                }
                List startNodeAndAncestors = this.addressSpaceScanner.scanReverse(client, operation.getDeviceId().getValue(), startNode);
                if (!CollectionUtils.isEmpty((Collection)startNodeAndAncestors)) {
                    startNode = (Node)startNodeAndAncestors.get(0);
                    if (!operation.isSkipSync()) {
                        List ancestors = startNodeAndAncestors.subList(1, startNodeAndAncestors.size());
                        for (Node node : ancestors) {
                            this.addressSpaceInventoryService.createOrUpdateNode(node, namespaceTable, serverId);
                        }
                    }
                }
            }
            long start = System.currentTimeMillis();
            ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(this.addressSpaceScanner.scan(client, operation.getDeviceId().getValue(), startNode, operation.isSkipSync()));
            log.info("Client scanning time: " + (System.currentTimeMillis() - start));
            this.eventPublisher.publishEvent((Object)new AddressSpaceUpdatedEvent(ServerIdentifier.of((String)operation.getDeviceId().getValue())));
            if (operation.isSkipSync()) {
                log.info("Skipped synchronization data into Cumulocity.");
                return new HandleInternalResult(null, true, null);
            }
            this.addressSpaceInventoryService.syncAndStoreAddressSpace(queue, startNode, namespaceTable, operation.getDeviceId(), this.operationTimeoutInMinutes);
            log.info("Finished scanning address space");
            return new HandleInternalResult(null, true, null);
        }
        catch (AddressSpaceInventorySyncException e) {
            HandleInternalResult errorResult = new HandleInternalResult();
            errorResult.setSuccessful(false);
            log.error(e.getMessage());
            return this.failScanWithReason(e.getMessage());
        }
        catch (Exception e) {
            HandleInternalResult errorResult = new HandleInternalResult();
            errorResult.setSuccessful(false);
            if (e instanceof OpcuaClientException) {
                log.error("Could not finish address space operation due to client exception.", (Throwable)e);
                return this.failScanWithReason("Could not finish address space scan due to client exception: " + e.getMessage());
            }
            log.error("Could not finish address space operation due to an internal, unexpected error occurred.", (Throwable)e);
            throw new OperationExecutionException((Throwable)e);
        }
    }

    private boolean isRootLevelAncestorFragmentPresent(ManagedObjectRepresentation nodeMo) {
        return nodeMo.getAttrs().containsKey("c8y_ua_AncestorNodeIds");
    }

    private HandleInternalResult failScanForLegacyStructure() {
        return this.failScanWithReason("Existing address space nodes contains old structure. Please do full scan to update");
    }

    private HandleInternalResult failScanWithReason(String reason) {
        log.warn("Could not finish address space scan, reason: {}", (Object)reason);
        HandleInternalResult errorResult = super.failWithReason(reason);
        return errorResult;
    }
}

