/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.BaseHistoricReadOperation;
import c8y.ua.command.HistoricDataUploadOperation;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.history.HistoricDataUploadingService;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.BaseHistoricOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.model.HistoricReadResult;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.encoding.EncodingException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HistoricDataUploadOperationHandler
extends BaseHistoricOperationHandler<HistoricDataUploadOperation> {
    private final HistoricDataUploadingService uploadingService;
    private static final int BATCH_SIZE = 100000;

    @Autowired
    public HistoricDataUploadOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, HistoricDataUploadingService uploadingService, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, HistoricDataUploadOperation.class, deviceControlApi, inventoryApi, nodeValidator);
        this.uploadingService = uploadingService;
    }

    protected HandleInternalResult handleInternal(HistoricDataUploadOperation operation) throws OperationExecutionException {
        return super.handleInternal((BaseHistoricReadOperation)operation);
    }

    protected int getDefaultBatchSize() {
        return 100000;
    }

    protected int processData(HistoricReadResult historicReadResult, HistoricDataUploadOperation operation, int batches) throws IOException, EncodingException {
        boolean last = !historicReadResult.getContinuationPoint().isPresent();
        List binaries = this.uploadingService.uploadHistoryData(historicReadResult.getDataValues(), operation, last, batches + 1);
        return binaries.size();
    }

    protected Command onCompleted(int batches, Supplier<Object> chunks) {
        Command command = new Command();
        command.setResult(String.format("%d batch(es) processed, %s chunks created", batches, chunks.get()));
        return command;
    }

    protected Set<String> getQueryNodes(HistoricDataUploadOperation operation) {
        return operation.getNodeId() != null ? Set.of(operation.getNodeId()) : Set.of();
    }
}

