/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.BaseOperation;
import c8y.ua.command.GetMethodDescriptionOperation;
import c8y.ua.data.MethodArgument;
import c8y.ua.data.MethodDescription;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetMethodDescriptionOperationHandler
extends UAOperationHandler<GetMethodDescriptionOperation> {
    private static final Logger log = LoggerFactory.getLogger(GetMethodDescriptionOperationHandler.class);

    @Autowired
    public GetMethodDescriptionOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, GetMethodDescriptionOperation.class, deviceControlApi, inventoryApi, nodeValidator);
    }

    protected HandleInternalResult handleInternal(GetMethodDescriptionOperation operation) throws OperationExecutionException {
        String nodeId = operation.getNodeId();
        Optional clientOptional = this.resolveClient((BaseOperation)operation);
        if (!clientOptional.isPresent()) {
            throw new OperationExecutionException("UA Server is not resolvable / not connected!");
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        try {
            MethodDescription methodDescription = client.getMethodDescription(nodeId);
            this.useNsUriForMethod(nodeId, methodDescription, client);
            String jsonValue = OpcuaSerializer.getInstance().toJson((Object)methodDescription);
            Command cmd = new Command();
            cmd.setResult(jsonValue);
            return new HandleInternalResult(cmd, true, null);
        }
        catch (OpcuaClientException e) {
            throw new OperationExecutionException((Throwable)e);
        }
    }

    private void useNsUriForMethod(String originalNodeId, MethodDescription method, OpcuaClient client) {
        method.setNodeId(NodeIds.toNodeIdWithNsUri((NamespaceTable)client.getNamespaceTable(), (String)originalNodeId));
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{method.getParentNodeId()})) {
            method.setParentNodeId(NodeIds.toNodeIdWithNsUri((NamespaceTable)client.getNamespaceTable(), (String)method.getParentNodeId()));
        }
        if (Objects.nonNull(method.getInputArguments())) {
            for (MethodArgument inputArg : method.getInputArguments()) {
                inputArg.setDataTypeId(NodeIds.toNodeIdWithNsUri((NamespaceTable)client.getNamespaceTable(), (String)inputArg.getDataTypeId()));
            }
        }
        if (Objects.nonNull(method.getOutputArguments())) {
            for (MethodArgument outputArg : method.getOutputArguments()) {
                outputArg.setDataTypeId(NodeIds.toNodeIdWithNsUri((NamespaceTable)client.getNamespaceTable(), (String)outputArg.getDataTypeId()));
            }
        }
    }

    protected Set<String> getQueryNodes(GetMethodDescriptionOperation operation) {
        return operation.getNodeId() != null ? Set.of(operation.getNodeId()) : Set.of();
    }
}

