/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.FindMatchingDeviceTypesOperation;
import com.cumulocity.model.event.CumulocityAlarmStatuses;
import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.model.util.ExtensibilityConverter;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAServerOperationHandler;
import com.cumulocity.opcua.client.gateway.subscription.DeviceTypeConverter;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.alarm.AlarmApi;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryFilter;
import com.cumulocity.sdk.client.inventory.PagedManagedObjectCollectionRepresentation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Deprecated
public class FindMatchingDeviceTypesOperationHandler
extends UAServerOperationHandler<FindMatchingDeviceTypesOperation> {
    private static final Logger log = LoggerFactory.getLogger(FindMatchingDeviceTypesOperationHandler.class);
    private static final String DEPRECATION_WARNING = "The FindMatchingDeviceTypesOperation is deprecated and will be removed in future versions. Please use the officially supported TestDeviceTypeMatching and DryRunDeviceTypeMatching operations";
    private final InventoryRepository inventoryRepository;
    private final DeviceTypeMatchingService deviceTypeMatchingService;
    private final AlarmApi alarmApi;

    @Autowired
    public FindMatchingDeviceTypesOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, ThreadPoolTaskExecutor executor, DeviceControlApi deviceControlApi, InventoryRepository inventoryRepository, DeviceTypeMatchingService deviceTypeMatchingService, AlarmApi alarmApi) {
        super(gatewayManager, connectionManager, FindMatchingDeviceTypesOperation.class, deviceControlApi);
        this.inventoryRepository = inventoryRepository;
        this.deviceTypeMatchingService = deviceTypeMatchingService;
        this.alarmApi = alarmApi;
    }

    private List<DeviceType> getAllDeviceTypes() {
        InventoryFilter deviceTypeFilter = new InventoryFilter().byType("c8y_OpcuaDeviceType");
        return StreamSupport.stream(((PagedManagedObjectCollectionRepresentation)this.inventoryRepository.getManagedObjectsByFilter(deviceTypeFilter).get(1000, new QueryParam[0])).allPages().spliterator(), false).filter(mo -> mo.hasProperty(ExtensibilityConverter.classToStringRepresentation(DeviceType.class))).map(arg_0 -> this.toDeviceType(arg_0)).collect(Collectors.toList());
    }

    private DeviceType toDeviceType(ManagedObjectRepresentation managedObject) {
        DeviceType deviceType = (DeviceType)managedObject.get(DeviceType.class);
        if (!Objects.isNull(deviceType)) {
            deviceType.setId(managedObject.getId().getValue());
        }
        DeviceTypeConverter.unEscapeHtml((DeviceType)deviceType);
        return deviceType;
    }

    protected HandleInternalResult handleInternal(FindMatchingDeviceTypesOperation operation) {
        this.warnAboutDeprecation(operation);
        List allDeviceTypes = this.getAllDeviceTypes();
        try {
            Collection matchingNodes = this.deviceTypeMatchingService.matches(operation.getDeviceId().getValue(), allDeviceTypes);
            String jsonValue = FindMatchingDeviceTypesOperationHandler.toJSON((Collection)matchingNodes);
            Command cmd = new Command();
            cmd.setResult(jsonValue);
            return new HandleInternalResult(cmd, true, null);
        }
        catch (ServerNotConnectedException e) {
            log.error("Cannot execute operation {}, because gateway is not connected to server.", (Object)operation.getOperationId());
            HandleInternalResult notConnectedResult = new HandleInternalResult();
            notConnectedResult.setFailureReason("Gateway is not connected to OPC UA server.");
            notConnectedResult.setSuccessful(false);
            return notConnectedResult;
        }
        catch (OpcuaClientException e) {
            log.warn("Could not finish matching device types operation. Original exception was {}", (Object)e.getMessage());
            HandleInternalResult errorResult = this.failWithReason("Could not complete address space operation: " + e.getMessage());
            return errorResult;
        }
    }

    private void warnAboutDeprecation(FindMatchingDeviceTypesOperation operation) {
        try {
            log.warn("The FindMatchingDeviceTypesOperation is deprecated and will be removed in future versions. Please use the officially supported TestDeviceTypeMatching and DryRunDeviceTypeMatching operations");
            ManagedObjectRepresentation deviceMo = new ManagedObjectRepresentation();
            deviceMo.setId(operation.getDeviceId());
            AlarmRepresentation alarmRepresentation = new AlarmRepresentation();
            alarmRepresentation.setText("The FindMatchingDeviceTypesOperation is deprecated and will be removed in future versions. Please use the officially supported TestDeviceTypeMatching and DryRunDeviceTypeMatching operations");
            alarmRepresentation.setSource(deviceMo);
            alarmRepresentation.setType("c8y_deprecated_operation");
            alarmRepresentation.setSeverity(CumulocitySeverities.WARNING.toString());
            alarmRepresentation.setStatus(CumulocityAlarmStatuses.ACTIVE.toString());
            alarmRepresentation.setDateTime(DateTime.now());
            this.alarmApi.create(alarmRepresentation);
        }
        catch (Exception e) {
            log.error("Could not log deprecation warning, error was", (Throwable)e);
        }
    }
}

