/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.HttpPostElement;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.AlarmCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.EventCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.HttpPostElementCreationTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.HttpPostTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.MeasurementCreationTask;
import com.cumulocity.opcua.common.model.mapping.ExecutableMappingAction;
import com.cumulocity.opcua.common.model.mapping.action.AlarmCreation;
import com.cumulocity.opcua.common.model.mapping.action.EventCreation;
import com.cumulocity.opcua.common.model.mapping.action.HttpPostAction;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.opcua.common.model.mapping.action.MeasurementCreation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class MappingExecutionTaskFactory {
    @Autowired
    private ApplicationContext context;

    public Runnable create(ExecutableMappingAction executableMappingAction, BaseDataValueEvent event, GId deviceId, boolean isTaggingEnabled) {
        MappingAction mappingAction = executableMappingAction.getMappingAction();
        if (mappingAction instanceof AlarmCreation) {
            AlarmCreationTask task = (AlarmCreationTask)this.context.getBean(AlarmCreationTask.class);
            task.setAlarmCreation((AlarmCreation)mappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            executableMappingAction.getProcessingMode().ifPresent(pm -> task.setProcessingMode(pm));
            return task;
        }
        if (mappingAction instanceof EventCreation) {
            EventCreation eventMappingAction = ((EventCreation)mappingAction).copy();
            if (isTaggingEnabled) {
                eventMappingAction.addHistoricTagWithType();
            }
            EventCreationTask task = (EventCreationTask)this.context.getBean(EventCreationTask.class);
            task.setEventCreation(eventMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            executableMappingAction.getProcessingMode().ifPresent(pm -> task.setProcessingMode(pm));
            return task;
        }
        if (mappingAction instanceof MeasurementCreation) {
            MeasurementCreation measurementMappingAction = ((MeasurementCreation)mappingAction).copy();
            if (isTaggingEnabled) {
                measurementMappingAction.addHistoricTagWithType();
                measurementMappingAction.setFragmentName(measurementMappingAction.getFragmentName(event.getNodeId()) + "_Historic");
            }
            MeasurementCreationTask task = (MeasurementCreationTask)this.context.getBean(MeasurementCreationTask.class);
            task.setMeasurementCreation(measurementMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            executableMappingAction.getProcessingMode().ifPresent(pm -> task.setProcessingMode(pm));
            return task;
        }
        if (mappingAction instanceof HttpPostAction) {
            HttpPostAction httpPostMappingAction = ((HttpPostAction)mappingAction).copy();
            if (isTaggingEnabled) {
                httpPostMappingAction.addHistoricTagWithType();
            }
            HttpPostElementCreationTask task = (HttpPostElementCreationTask)this.context.getBean(HttpPostElementCreationTask.class);
            task.setPostAction(httpPostMappingAction);
            task.setEvent(event);
            task.setDeviceId(deviceId);
            return task;
        }
        throw new RuntimeException("Unknown mappingAction class: " + mappingAction.getClass().getName());
    }

    public Runnable createHttpPostTask(HttpPostElement httpPost) {
        HttpPostTask task = (HttpPostTask)this.context.getBean(HttpPostTask.class);
        task.httpPostElement = httpPost;
        task.setDeviceId(new GId(httpPost.getServerId()));
        return task;
    }

    public Runnable createHistoric(ExecutableMappingAction executableMappingAction, boolean isTaggingEnabled, BaseDataValueEvent event, GId deviceId) {
        if (isTaggingEnabled) {
            return this.create(executableMappingAction, event, deviceId, true);
        }
        return this.create(executableMappingAction, event, deviceId, false);
    }
}

