/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.jmx.CustomActionMBean;
import com.cumulocity.opcua.client.gateway.mappingsexecution.HttpPostQueue;
import com.cumulocity.opcua.client.gateway.mappingsexecution.HttpRequestExecutor;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.HttpPostElement;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseTask;
import com.cumulocity.opcua.client.gateway.platform.repository.aggregate.DataAggregator;
import com.cumulocity.opcua.common.builder.AlarmBuilder;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class HttpPostTask
extends BaseTask {
    private static final Logger log = LoggerFactory.getLogger(HttpPostTask.class);
    HttpPostElement httpPostElement;
    private HttpResponse response;
    @Value(value="${gateway.mappingExecution.http.failureHandling.enabled:false}")
    private boolean failureHandlingEnabled;
    @Autowired
    private DataAggregator<AlarmRepresentation> alarmAggregator;
    @Autowired
    private HttpPostQueue queue;
    @Autowired
    private HttpRequestExecutor httpRequestExecutor;
    @Autowired
    private CustomActionMBean customActionMBean;

    public void run() {
        int statusCode = -1;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Creating HTTP POST call for server: {} to endpoint: {}", (Object)this.httpPostElement.getServerId(), (Object)this.httpPostElement.getEndpoint());
            }
            this.response = this.httpRequestExecutor.httpPostRequest(this.httpPostElement.getEndpoint(), this.httpPostElement.getHeaders(), (HttpEntity)new StringEntity(this.httpPostElement.getRequestBody(), StandardCharsets.UTF_8));
            statusCode = this.response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                this.queue.onFailed(this.httpPostElement, (long)statusCode);
                log.error("Creating alarm!");
                this.raiseAlarm("HttpRequest for action:\n" + this.httpPostElement.getEndpoint() + "\n\nreturned status code: " + statusCode);
            }
        }
        catch (IOException e) {
            log.error("IOException on http post: {}", (Object)e.getMessage());
            this.queue.onFailed(this.httpPostElement, (long)statusCode);
            this.raiseAlarm("Couldn't send httpRequest:\n" + this.httpPostElement.getEndpoint() + "\n\nerror message: " + e.getMessage());
        }
        finally {
            this.customActionMBean.touch(this.httpPostElement.getEndpoint(), String.valueOf(statusCode), Integer.valueOf(this.httpPostElement.getRetries()));
            if (Objects.nonNull(this.response)) {
                EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            }
        }
    }

    private void raiseAlarm(String errorMessage) {
        AlarmRepresentation alarm = AlarmBuilder.builder().sourceId(this.getDeviceId()).severity(CumulocitySeverities.MAJOR.name()).type("opcuaHttpPostError").text(errorMessage).prepare().build();
        this.alarmAggregator.aggregate((AbstractExtensibleRepresentation)alarm);
    }

    public void setHttpPostElement(HttpPostElement httpPostElement) {
        this.httpPostElement = httpPostElement;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public void setFailureHandlingEnabled(boolean failureHandlingEnabled) {
        this.failureHandlingEnabled = failureHandlingEnabled;
    }

    public void setAlarmAggregator(DataAggregator<AlarmRepresentation> alarmAggregator) {
        this.alarmAggregator = alarmAggregator;
    }

    public void setQueue(HttpPostQueue queue) {
        this.queue = queue;
    }

    public void setHttpRequestExecutor(HttpRequestExecutor httpRequestExecutor) {
        this.httpRequestExecutor = httpRequestExecutor;
    }

    public void setCustomActionMBean(CustomActionMBean customActionMBean) {
        this.customActionMBean = customActionMBean;
    }

    public HttpResponse getResponse() {
        return this.response;
    }
}

