/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution;

import c8y.ua.ClientConfig;
import com.cumulocity.model.event.CumulocityAlarmStatuses;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.addressspace.modelchange.model.ModelChangeEvent;
import com.cumulocity.opcua.client.gateway.configuration.MappingsConfiguration;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.connection.model.ServerConnectedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerReconnectedEvent;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.EventRepository;
import com.cumulocity.opcua.client.gateway.subscription.model.EventReceivedEvent;
import com.cumulocity.opcua.client.gateway.subscription.model.EventSubscribedItem;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItem;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.cumulocity.opcua.common.expression.ServerAlarmStatusMapper;
import com.cumulocity.opcua.common.model.mapping.ExecutableMappingAction;
import com.cumulocity.opcua.common.model.mapping.action.AlarmCreation;
import com.cumulocity.opcua.common.model.mapping.action.EventCreation;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.event.EventRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import io.vavr.API;
import io.vavr.Predicates;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UaEventMappingsExecutor {
    private static final Logger log = LoggerFactory.getLogger(UaEventMappingsExecutor.class);
    private static final String SEVERITY_ATTR = "Severity";
    private static final String UNKNOWN_ALARM_STATUS = "UNKNOWN";
    @Autowired
    private AlarmRepository alarmRepository;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private MappingsConfiguration mappingsConfiguration;
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private Map<String, ServerAlarmStatusMapper> alarmStatusMappers = new HashMap();

    @EventListener(value={EventReceivedEvent.class})
    public void handleEvent(EventReceivedEvent event) {
        Optional subscribedItemMaybe = this.subscriptionRepository.getSubscribedItem(event.getServerId(), event.getNodeId(), event.getMonitoredItemId());
        if (!subscribedItemMaybe.isPresent()) {
            if (this.isModelChangeEvent(event)) {
                this.eventPublisher.publishEvent((Object)new ModelChangeEvent(event.getServerId(), event.getVariants()));
            } else {
                log.warn("Mapping not found for event: {}", (Object)event);
            }
            return;
        }
        Collection eventMappedActions = ((SubscribedItem)subscribedItemMaybe.get()).getMappedActions();
        try {
            for (ExecutableMappingAction action : eventMappedActions) {
                this.handleAction(event.getServerId(), action, event.getNodeId(), event.getVariants(), (SubscribedItem)subscribedItemMaybe.get());
            }
        }
        catch (Exception e) {
            log.error("Unable to handle event:\n {}\n {}", (Object)event, (Object)e.getMessage());
        }
    }

    @EventListener(value={ServerConnectedEvent.class})
    public void onServerConnected(ServerConnectedEvent event) {
        this.updateAlarmStatusMappers(event.getServerIdentifier(), event.getClientConfig());
    }

    @EventListener(value={ServerReconnectedEvent.class})
    public void onServerReconnected(ServerReconnectedEvent event) {
        this.updateAlarmStatusMappers(event.getServerIdentifier(), event.getClientConfig());
    }

    private void updateAlarmStatusMappers(ServerIdentifier serverIdentifier, ClientConfig clientConfig) {
        String serverId;
        if (Objects.nonNull(serverIdentifier) && this.alarmStatusMappers.containsKey(serverId = serverIdentifier.getInventoryIdentifier().getValue())) {
            ServerAlarmStatusMapper alarmStatusMapper = new ServerAlarmStatusMapper(clientConfig.getAlarmStatusMappings());
            this.alarmStatusMappers.put(serverId, alarmStatusMapper);
        }
    }

    private boolean isModelChangeEvent(EventReceivedEvent event) {
        NodeId eventType;
        Variant[] variants = event.getVariants();
        return NodeId.class.equals((Object)variants[0].getCompositeClass()) && (Identifiers.BaseModelChangeEventType.equals((Object)(eventType = (NodeId)variants[0].asClass(NodeId.class, (Object)Identifiers.BaseEventType))) || Identifiers.GeneralModelChangeEventType.equals((Object)eventType) || Identifiers.SemanticChangeEventType.equals((Object)eventType));
    }

    private void handleAction(String serverId, ExecutableMappingAction action, String nodeId, Variant[] variants, SubscribedItem subscribedItem) {
        log.debug("Handling event from server {} and node {} with variants size: {}", new Object[]{serverId, nodeId, variants.length});
        log.debug("Target device ID: " + String.valueOf(action.getSourceDeviceId()));
        if (action.getMappingAction() instanceof AlarmCreation) {
            AlarmCreation alarmCreation = (AlarmCreation)action.getMappingAction();
            String alarmStatus = this.getAlarmStatus(serverId, alarmCreation, subscribedItem, variants);
            String alarmType = this.replacePlaceholders(alarmCreation.getType(), variants);
            API.Match((Object)alarmStatus).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new String[]{CumulocityAlarmStatuses.ACTIVE.name(), UNKNOWN_ALARM_STATUS})), () -> API.run(() -> {
                if (alarmStatus.equals(UNKNOWN_ALARM_STATUS)) {
                    log.warn("Alarm status from {} and type {} returned unknown status. Assumed as {}", new Object[]{serverId, alarmType, CumulocityAlarmStatuses.ACTIVE.name()});
                }
                this.createAlarm(action.getSourceDeviceId(), this.getAlarmSeverity(serverId, alarmCreation, subscribedItem, variants), CumulocityAlarmStatuses.ACTIVE.name(), nodeId, alarmType, this.replacePlaceholders(alarmCreation.getText(), variants));
            })), API.Case((API.Match.Pattern0)API.$((Object)CumulocityAlarmStatuses.ACKNOWLEDGED.name()), () -> API.run(() -> this.acknowledgeAlarm(action.getSourceDeviceId(), this.getAlarmSeverity(serverId, alarmCreation, subscribedItem, variants), CumulocityAlarmStatuses.ACKNOWLEDGED.name(), nodeId, alarmType, this.replacePlaceholders(alarmCreation.getText(), variants)))), API.Case((API.Match.Pattern0)API.$((Object)CumulocityAlarmStatuses.CLEARED.name()), () -> API.run(() -> this.clearAlarm(action.getSourceDeviceId(), alarmType))), API.Case((API.Match.Pattern0)API.$(), () -> {
                throw new IllegalArgumentException(String.format("Unknown alarmStatus %s coming from OPC-UA server", alarmStatus));
            })});
        }
        if (action.getMappingAction() instanceof EventCreation) {
            this.createEvent(action.getSourceDeviceId(), nodeId, (EventCreation)action.getMappingAction(), variants);
        }
    }

    private void createEvent(GId sourceDeviceId, String nodeId, EventCreation eventCreation, Variant[] variants) {
        log.debug("Creating event");
        ManagedObjectRepresentation sourceMo = new ManagedObjectRepresentation();
        sourceMo.setId(GId.asGId((Object)sourceDeviceId));
        EventRepresentation eventRepresentation = new EventRepresentation();
        eventRepresentation.setSource(sourceMo);
        eventRepresentation.setDateTime(new DateTime());
        eventRepresentation.setCreationDateTime(null);
        eventRepresentation.setType(this.replacePlaceholders(eventCreation.getType(), variants));
        eventRepresentation.setText(this.replacePlaceholders(eventCreation.getText(), variants));
        eventRepresentation.setProperty("c8y_ua_SourceNodeId_" + nodeId, new HashMap());
        this.eventRepository.addToQueue((AbstractExtensibleRepresentation)eventRepresentation);
    }

    private void createAlarm(GId sourceDeviceId, String alarmSeverity, String alarmStatus, String nodeId, String type, String text) {
        log.debug("Creating alarm");
        AlarmRepresentation alarmRepresentation = this.alarmRepository.buildAlarm(GId.asGId((Object)sourceDeviceId), type, alarmSeverity, alarmStatus, text, new DateTime());
        alarmRepresentation.setProperty("c8y_ua_SourceNodeId_" + nodeId, new HashMap());
        this.alarmRepository.addToQueue((AbstractExtensibleRepresentation)alarmRepresentation);
        if (log.isDebugEnabled()) {
            log.debug("Created alarm from source: {} status set to {}, type is {}, severity is {}", new Object[]{sourceDeviceId.getValue(), alarmRepresentation.getStatus(), alarmRepresentation.getType(), alarmRepresentation.getSeverity()});
        }
    }

    private void acknowledgeAlarm(GId sourceDeviceId, String alarmSeverity, String alarmStatus, String nodeId, String type, String text) {
        log.debug("Acknowledge alarm");
        AlarmRepresentation alarmRepresentation = this.alarmRepository.buildAlarm(GId.asGId((Object)sourceDeviceId), type, alarmSeverity, alarmStatus, text, new DateTime());
        alarmRepresentation.setProperty("c8y_ua_SourceNodeId_" + nodeId, new HashMap());
        AlarmRepresentation acknowledgedAlarm = this.alarmRepository.acknowledge(sourceDeviceId.getValue() + ":" + type, alarmRepresentation);
        if (log.isDebugEnabled()) {
            log.debug("Acknowledged alarm from source: {} status set to {}, type is {}, severity is {} for alarm {}", new Object[]{sourceDeviceId.getValue(), alarmRepresentation.getStatus(), alarmRepresentation.getType(), alarmRepresentation.getSeverity(), acknowledgedAlarm.getId().getValue()});
        }
    }

    private void clearAlarm(GId sourceDeviceId, String type) {
        log.debug("Clear alarm");
        AlarmRepresentation clearedAlarm = this.alarmRepository.clear(sourceDeviceId.getValue() + ":" + type);
        if (log.isDebugEnabled()) {
            log.debug("Cleared alarm from source: {} , type is {}, alarmId {}", new Object[]{sourceDeviceId.getValue(), type, clearedAlarm != null ? clearedAlarm.getId() : "not found"});
        }
    }

    private String replacePlaceholders(String pattern, Variant[] variants) {
        for (int i = 0; i < variants.length; ++i) {
            if (!Objects.nonNull(variants[i]) || !Objects.nonNull(variants[i].getValue())) continue;
            pattern = pattern.replaceAll("\\$\\{" + i + "}", variants[i].getValue().toString());
        }
        return pattern;
    }

    private String getAlarmSeverity(String serverId, AlarmCreation alarmCreation, SubscribedItem subscribedItem, Variant[] variants) {
        if (Objects.nonNull(alarmCreation.getSeverity())) {
            return alarmCreation.getSeverity();
        }
        if (subscribedItem instanceof EventSubscribedItem) {
            Optional clientConfig = this.connectionManager.getClientConfig(ServerIdentifier.of((String)serverId));
            if (!clientConfig.isPresent()) {
                log.warn("Server not connected!");
                return this.mappingsConfiguration.getDefaultAlarmSeverity();
            }
            int idxOfSeverity = this.findSeverityAttributeIndex(((EventSubscribedItem)subscribedItem).getAttributes());
            if (idxOfSeverity < 0 || variants.length - 1 < idxOfSeverity) {
                return this.mappingsConfiguration.getDefaultAlarmSeverity();
            }
            int uaSeverity = variants[idxOfSeverity].intValue();
            if (CollectionUtils.isEmpty((Map)((ClientConfig)clientConfig.get()).getNavigableUaAlarmSeverityMappings())) {
                return this.mappingsConfiguration.getCumulocityAlarmSeverity(uaSeverity);
            }
            return this.mappingsConfiguration.getCumulocityAlarmSeverity(((ClientConfig)clientConfig.get()).getNavigableUaAlarmSeverityMappings(), uaSeverity);
        }
        return this.mappingsConfiguration.getDefaultAlarmSeverity();
    }

    private String getAlarmStatus(String serverId, AlarmCreation alarmCreation, SubscribedItem subscribedItem, Variant[] variants) {
        if (Objects.nonNull(alarmCreation.getStatus())) {
            return alarmCreation.getStatus();
        }
        Map variantMap = this.getVariantMap((EventSubscribedItem)subscribedItem, variants);
        ServerAlarmStatusMapper alarmStatusMapper = (ServerAlarmStatusMapper)this.alarmStatusMappers.get(serverId);
        if (Objects.isNull(alarmStatusMapper)) {
            Optional clientConfig = this.connectionManager.getClientConfig(ServerIdentifier.of((String)serverId));
            if (!clientConfig.isPresent()) {
                log.warn("Server not connected");
                return "Server not connected";
            }
            if (CollectionUtils.isEmpty((Map)((ClientConfig)clientConfig.get()).getAlarmStatusMappings())) {
                return UNKNOWN_ALARM_STATUS;
            }
            log.info("Constructing server alarm status mapper, server ID: {}, mappings: {}", (Object)serverId, (Object)((ClientConfig)clientConfig.get()).getAlarmStatusMappings());
            alarmStatusMapper = new ServerAlarmStatusMapper(((ClientConfig)clientConfig.get()).getAlarmStatusMappings());
            this.alarmStatusMappers.put(serverId, alarmStatusMapper);
        }
        return alarmStatusMapper.map((Object)variantMap).orElse(UNKNOWN_ALARM_STATUS);
    }

    private Map<String, Object> getVariantMap(EventSubscribedItem eventSubscribedItem, Variant[] variants) {
        HashMap<String, Object> variantMap = new HashMap<String, Object>();
        for (int i = 0; i < eventSubscribedItem.getAttributes().size(); ++i) {
            String attributeName = (String)eventSubscribedItem.getAttributes().get(i);
            String simpleName = QualifiedName.parseQualifiedName((String)attributeName).getName();
            Object value = null;
            if (i < variants.length && Objects.nonNull(variants[i])) {
                value = variants[i].getValue();
            }
            variantMap.put(attributeName, value);
            variantMap.put(simpleName, value);
        }
        return variantMap;
    }

    private int findSeverityAttributeIndex(List<String> attributes) {
        if (CollectionUtils.isEmpty(attributes)) {
            return -1;
        }
        for (int i = 0; i < attributes.size(); ++i) {
            if (!SEVERITY_ATTR.equals(QualifiedName.parseQualifiedName((String)attributes.get(i)).getName())) continue;
            return i;
        }
        return -1;
    }
}

