/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.jmx;

import com.cumulocity.opcua.client.gateway.jmx.CustomActionRequestKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@ManagedResource
@Component
public class CustomActionMBean {
    private static final Logger log = LoggerFactory.getLogger(CustomActionMBean.class);
    private final Map<CustomActionRequestKey, Long> customActionCounterMap = new ConcurrentHashMap();
    private long customActionQueueSize = 0L;

    public void touch(String url, String httpResponseCode, Integer retryCount) {
        CustomActionRequestKey customActionKey = new CustomActionRequestKey(url, httpResponseCode, retryCount);
        this.customActionCounterMap.computeIfPresent(customActionKey, (key, val) -> val == null || val == Long.MAX_VALUE ? 1L : val + 1L);
        this.customActionCounterMap.computeIfAbsent(customActionKey, k -> 1L);
    }

    @ManagedAttribute
    public TabularData getCounterTable() throws Exception {
        CompositeType compositeType = new CompositeType("CustomActionCounter", "custom action counter", new String[]{"key", "value"}, new String[]{"key", "value"}, new OpenType[]{SimpleType.STRING, SimpleType.LONG});
        TabularType tabularType = new TabularType("CustomActionCounterTable", "custom action counter table", compositeType, new String[]{"key"});
        TabularDataSupport rows = new TabularDataSupport(tabularType);
        CompositeData[] compositeData = new CompositeData[this.customActionCounterMap.size()];
        int i = 0;
        for (CustomActionRequestKey customActionRequestKey : this.customActionCounterMap.keySet()) {
            CompositeDataSupport compositeDataSupport = new CompositeDataSupport(compositeType, new String[]{"key", "value"}, new Object[]{customActionRequestKey.toString(), this.customActionCounterMap.get(customActionRequestKey)});
            compositeData[i] = compositeDataSupport;
            ++i;
        }
        rows.putAll(compositeData);
        return rows;
    }

    public void setRetryQueueSize(long size) {
        this.customActionQueueSize = size;
    }

    @ManagedAttribute
    public Long getRetryQueueSize() {
        return this.customActionQueueSize;
    }
}

