/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.datavalue.repository;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.configuration.InventoryUpdateProcessingModeConfiguration;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class DataValueStatusAlarmRepository {
    private static final Logger log = LoggerFactory.getLogger(DataValueStatusAlarmRepository.class);
    private static final String DATAVALUE_ABNORMAL_ALARM_SEVERITY = "WARNING";
    private Map<String, Map<String, BaseDataValueEvent>> abnormalValAlarmsToCreate = new ConcurrentHashMap();
    private Map<String, Map<String, String>> abnormalValAlarmsActive = new ConcurrentHashMap();
    private Map<String, Map<String, String>> abnormalValAlarmsToClear = new ConcurrentHashMap();
    @Autowired
    @Qualifier(value="pmAwareInventoryRepository")
    private InventoryRepository inventoryRepository;
    @Autowired
    private AlarmRepository alarmRepository;
    @Autowired
    private InventoryUpdateProcessingModeConfiguration processingModeConfiguration;

    public void loadActiveAlarms(GId serverId) {
        try {
            ManagedObjectRepresentation serverMo = this.inventoryRepository.get(serverId);
            Map activeAlarms = (Map)serverMo.get("c8y_ua_DataValueAbnormalAlarms");
            if (activeAlarms != null) {
                Map alarmsActiveForServer = this.getActiveAlarmsForServer(serverId.getValue());
                alarmsActiveForServer.putAll(activeAlarms);
                log.debug("Restored the following active data value abnormal alarms for server {}: {}", (Object)serverId, (Object)alarmsActiveForServer);
            }
        }
        catch (SDKException e) {
            log.error("Loading active alarms to memory failed for server {}", (Object)serverId, (Object)e);
        }
    }

    public Map<String, Map<String, BaseDataValueEvent>> getAlarmsToCreate() {
        return this.abnormalValAlarmsToCreate;
    }

    public Map<String, Map<String, String>> getAlarmsToClear() {
        return this.abnormalValAlarmsToClear;
    }

    public Map<String, Map<String, String>> getActiveAlarms() {
        return this.abnormalValAlarmsActive;
    }

    private Map<String, BaseDataValueEvent> getAlarmsToCreateForServer(String serverId) {
        ConcurrentHashMap alarmsToCreateForServer = (ConcurrentHashMap)this.abnormalValAlarmsToCreate.get(serverId);
        if (alarmsToCreateForServer == null) {
            alarmsToCreateForServer = new ConcurrentHashMap();
            this.abnormalValAlarmsToCreate.put(serverId, alarmsToCreateForServer);
        }
        return alarmsToCreateForServer;
    }

    private Map<String, String> getAlarmsToClearForServer(String serverId) {
        ConcurrentHashMap alarmsToClearForServer = (ConcurrentHashMap)this.abnormalValAlarmsToClear.get(serverId);
        if (alarmsToClearForServer == null) {
            alarmsToClearForServer = new ConcurrentHashMap();
            this.abnormalValAlarmsToClear.put(serverId, alarmsToClearForServer);
        }
        return alarmsToClearForServer;
    }

    private Map<String, String> getActiveAlarmsForServer(String serverId) {
        ConcurrentHashMap alarmsActiveForServer = (ConcurrentHashMap)this.abnormalValAlarmsActive.get(serverId);
        if (alarmsActiveForServer == null) {
            alarmsActiveForServer = new ConcurrentHashMap();
            this.abnormalValAlarmsActive.put(serverId, alarmsActiveForServer);
        }
        return alarmsActiveForServer;
    }

    public boolean containedInActiveAlarmForServerNode(String serverId, String nodeId) {
        Optional alarm = this.getActiveAlarmsForServerNode(serverId, nodeId);
        return alarm.isPresent();
    }

    public Optional<GId> getActiveAlarmsForServerNode(String serverId, String nodeId) {
        Map alarmsForServer = this.getActiveAlarmsForServer(serverId);
        GId alarmId = GId.asGId((String)((String)alarmsForServer.get(nodeId)));
        if (alarmId == null) {
            return Optional.empty();
        }
        return Optional.of(alarmId);
    }

    public boolean containedInAlarmToCreateForServerNode(String serverId, String nodeId) {
        Map alarmsToCreate = this.getAlarmsToCreateForServer(serverId);
        return !Objects.isNull(alarmsToCreate.get(nodeId));
    }

    public void setAlarmToCreateForServer(String serverId, String nodeId, BaseDataValueEvent event) {
        Map alarmsToCreateForServer = this.getAlarmsToCreateForServer(serverId);
        alarmsToCreateForServer.put(nodeId, event);
    }

    public void setActiveAlarmForServer(String serverId, String nodeId, GId alarmId) {
        Map alarmsActiveForServer = this.getActiveAlarmsForServer(serverId);
        alarmsActiveForServer.put(nodeId, alarmId.getValue());
    }

    public void setAlarmToClearForServer(String serverId, String nodeId, GId alarmId) {
        Map alarmsToClearForServer = this.getAlarmsToClearForServer(serverId);
        alarmsToClearForServer.put(nodeId, alarmId.getValue());
    }

    public void removeFromAlarmsToCreate(String serverId, String nodeId) {
        this.getAlarmsToCreateForServer(serverId).remove(nodeId);
    }

    public void removeFromActiveAlarms(String serverId, String nodeId) {
        this.getActiveAlarmsForServer(serverId).remove(nodeId);
    }

    public void removeFromAlarmsToClear(String serverId, String nodeId) {
        this.getAlarmsToClearForServer(serverId).remove(nodeId);
    }

    public Optional<AlarmRepresentation> createAlarmForServer(String serverId, BaseDataValueEvent event) {
        AlarmRepresentation alarm = new AlarmRepresentation();
        alarm.setType(this.getAlarmType(event));
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(new GId(serverId));
        alarm.setSource(source);
        alarm.setSeverity(DATAVALUE_ABNORMAL_ALARM_SEVERITY);
        alarm.setText(this.getAlarmText(event));
        if (Objects.isNull(event.getValue()) || Objects.isNull(event.getValue().getServerTimestamp())) {
            alarm.setDateTime(new DateTime());
        } else {
            alarm.setDateTime(new DateTime(event.getValue().getServerTimestamp().getTimeInMillis()));
        }
        try {
            return Optional.of(this.alarmRepository.create(alarm));
        }
        catch (SDKException e) {
            log.error("Alarm creation failed for the abnormal data value event {}", (Object)event, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<AlarmRepresentation> clearAlarmForServer(String serverId, String nodeId, GId alarmId) {
        try {
            return Optional.of(this.alarmRepository.clear(alarmId));
        }
        catch (SDKException e) {
            log.error("Alarm clearing failed for the abnormal data value event for server {} and node {}", (Object)serverId, (Object)nodeId);
            return Optional.empty();
        }
    }

    public void persistActiveAlarmsForServer(String serverId) {
        Map activeAlarms = this.getActiveAlarmsForServer(serverId);
        ManagedObjectRepresentation serverMo = new ManagedObjectRepresentation();
        serverMo.setId(new GId(serverId));
        serverMo.set((Object)activeAlarms, "c8y_ua_DataValueAbnormalAlarms");
        try {
            this.inventoryRepository.update(serverMo, this.processingModeConfiguration.getServerUpdateProcessingMode());
        }
        catch (SDKException e) {
            log.error("Persisting active alarms to the server {} failed. Skipping.", (Object)serverId, (Object)e);
        }
    }

    private String getAlarmType(BaseDataValueEvent event) {
        StatusCode statusCode;
        StatusCode statusCode2 = statusCode = Objects.isNull(event.getValue()) ? null : event.getValue().getStatusCode();
        if (Objects.isNull(statusCode)) {
            return "c8y_ua_DataValueAbnormal_" + event.getNodeId();
        }
        return String.format("%s%s_%s_%s", "c8y_ua_DataValueAbnormal_", event.getNodeId(), statusCode.getName(), statusCode.getValue());
    }

    private String getAlarmText(BaseDataValueEvent event) {
        StatusCode statusCode;
        StatusCode statusCode2 = statusCode = Objects.isNull(event.getValue()) ? null : event.getValue().getStatusCode();
        if (Objects.isNull(statusCode)) {
            return String.format("Node %s has abnormal value. Skipping this read", event.getNodeId());
        }
        return String.format("Node %s has abnormal value with status code: %s %s %s. Skipping this read", event.getNodeId(), statusCode.getName(), statusCode.getValue(), statusCode.getDescription());
    }
}

