/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.datastore;

import com.cumulocity.opcua.client.gateway.datastore.DataStore;
import com.cumulocity.opcua.client.gateway.datastore.MapDbWrapper;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDbHTreeMapDataStore
implements DataStore {
    private static final Logger log = LoggerFactory.getLogger(MapDbHTreeMapDataStore.class);
    private static final String COMMON_MAP_KEY = "common";
    private MapDbWrapper db;

    public MapDbHTreeMapDataStore(MapDbWrapper db) {
        this.db = db;
    }

    public void store(String key, Serializable value) {
        HTreeMap map = this.createOrOpenMap(COMMON_MAP_KEY, null);
        map.put((Object)key, (Object)value);
        this.db.commit();
    }

    public void store(String collection, String key, Serializable value, long ttl) {
        HTreeMap map = this.createOrOpenMap(collection, Long.valueOf(ttl));
        map.put((Object)key, (Object)value);
        this.db.commit();
    }

    public <T extends Serializable> Optional<T> get(String key) {
        return this.get(COMMON_MAP_KEY, key);
    }

    public <T extends Serializable> Optional<T> get(String collection, String key) {
        HTreeMap map = this.createOrOpenMap(collection, null);
        try {
            return Optional.ofNullable((Serializable)map.get((Object)key));
        }
        catch (Exception e) {
            this.getLog().warn("Unable to get from collection {} using key {}: {}:{}", new Object[]{collection, key, e.getClass(), e.getMessage()});
            return Optional.empty();
        }
    }

    public <T extends Serializable> Optional<T> remove(String collection, String key) {
        HTreeMap map = this.createOrOpenMap(collection, null);
        Optional<Serializable> previousVal = Optional.ofNullable((Serializable)map.remove((Object)key));
        this.db.commit();
        return previousVal;
    }

    public void remove(String key) {
        HTreeMap map = this.createOrOpenMap(COMMON_MAP_KEY, null);
        map.remove((Object)key);
        this.db.commit();
    }

    public boolean isClosed() {
        return this.db.isClosed();
    }

    @PreDestroy
    public void close() {
        log.info("Removing crash entry from db...");
        this.remove("gateway_crash_check");
        this.getLog().info("Closing db...");
        if (!this.db.isClosed()) {
            this.db.close();
        }
        this.getLog().info("Db is closed!");
    }

    private HTreeMap createOrOpenMap(String mapKey, Long ttl) {
        DB.HashMapMaker mapMaker = this.db.hashMap(mapKey).keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.JAVA);
        if (Objects.nonNull(ttl)) {
            mapMaker = mapMaker.expireAfterCreate(ttl.longValue(), TimeUnit.MILLISECONDS).expireAfterUpdate(ttl.longValue(), TimeUnit.MILLISECONDS);
        }
        return mapMaker.createOrOpen();
    }

    private Logger getLog() {
        return log;
    }
}

