/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.cyclicreader;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.cyclicreader.model.CyclicReadDefinition;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueAbnormalStatusCodeEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueReadSuccessfulEvent;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ReaderTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReaderTask.class);
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private CyclicReadDefinition cyclicReadDefinition;

    @Override
    public void run() {
        try {
            Optional connection = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)this.cyclicReadDefinition.getServerId())));
            if (connection.isPresent()) {
                OpcuaClient client = (OpcuaClient)connection.get();
                long start = System.currentTimeMillis();
                DataValue[] values = client.readValues(this.cyclicReadDefinition.getNodeIds(), this.cyclicReadDefinition.getMaxAge());
                if (log.isDebugEnabled()) {
                    log.debug("Read {} values, took {} milliseconds", (Object)values.length, (Object)(System.currentTimeMillis() - start));
                }
                for (int i = 0; i < values.length; ++i) {
                    this.publishReadEvent(values[i], this.cyclicReadDefinition.getNodeIds()[i]);
                }
            } else {
                log.warn("Server connection " + this.cyclicReadDefinition.getServerId() + " not available. Skipping cyclic read!");
            }
        }
        catch (OpcuaClientException e) {
            log.warn("Error invoking readValue for cyclic read: " + String.valueOf(this.cyclicReadDefinition));
            log.warn(e.getMessage(), (Throwable)e);
            log.warn("Skipping.");
        }
    }

    private void publishReadEvent(DataValue value, NodeId nodeId) {
        if (Objects.nonNull(value.getStatusCode()) && value.getStatusCode().isNotGood()) {
            this.eventPublisher.publishEvent((Object)new ValueAbnormalStatusCodeEvent(this.cyclicReadDefinition.getServerId(), nodeId.toString(), value));
        } else {
            this.eventPublisher.publishEvent((Object)new ValueReadSuccessfulEvent(this.cyclicReadDefinition.getServerId(), nodeId.toString(), value, this.cyclicReadDefinition.getDeviceTypeId(), this.cyclicReadDefinition.getRootNodeId()));
        }
    }

    public void setCyclicReadDefinition(CyclicReadDefinition cyclicReadDefinition) {
        this.cyclicReadDefinition = cyclicReadDefinition;
    }
}

