/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import com.cumulocity.model.event.CumulocitySeverities;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@EnableConfigurationProperties
@Configuration
@ConfigurationProperties(prefix="gateway.mappings")
public class MappingsConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MappingsConfiguration.class);
    private static final String OUT_OF_RANGE_ALARM_SEVERITY = "CRITICAL";
    private static final String DEFAULT_ALARM_SEVERITY = "CRITICAL";
    private static final NavigableMap<Integer, String> DEFAULT_ALARM_SEVERITY_MAP = new TreeMap();
    private NavigableMap<Integer, String> alarmSeverityMap;

    public MappingsConfiguration(NavigableMap<Integer, String> alarmSeverityMap) {
        this.alarmSeverityMap = alarmSeverityMap;
    }

    public String getCumulocityAlarmSeverity(int uaSeverity) {
        return this.getCumulocityAlarmSeverity(this.getEffectiveAlarmSeverityMap(), uaSeverity);
    }

    public String getCumulocityAlarmSeverity(NavigableMap<Integer, String> alarmSeverityMap, int uaSeverity) {
        Map.Entry<Integer, String> entry = alarmSeverityMap.floorEntry(uaSeverity);
        return Objects.isNull(entry) ? "CRITICAL" : entry.getValue();
    }

    public String getDefaultAlarmSeverity() {
        return "CRITICAL";
    }

    public NavigableMap<Integer, String> getEffectiveAlarmSeverityMap() {
        if (CollectionUtils.isEmpty((Map)this.alarmSeverityMap)) {
            return DEFAULT_ALARM_SEVERITY_MAP;
        }
        return this.alarmSeverityMap;
    }

    public void afterPropertiesSet() {
        this.buildDefaultSeverityMappings();
    }

    private void buildDefaultSeverityMappings() {
        DEFAULT_ALARM_SEVERITY_MAP.put(1, CumulocitySeverities.WARNING.name());
        DEFAULT_ALARM_SEVERITY_MAP.put(401, CumulocitySeverities.MINOR.name());
        DEFAULT_ALARM_SEVERITY_MAP.put(601, CumulocitySeverities.MAJOR.name());
        DEFAULT_ALARM_SEVERITY_MAP.put(801, CumulocitySeverities.CRITICAL.name());
        DEFAULT_ALARM_SEVERITY_MAP.put(1001, CumulocitySeverities.CRITICAL.name());
    }

    public NavigableMap<Integer, String> getAlarmSeverityMap() {
        return this.alarmSeverityMap;
    }
}

