/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import c8y.ua.data.DeviceTypeMappedNodeCollection;
import com.cumulocity.opcua.client.gateway.datastore.AddressSpaceFileDataStore;
import com.cumulocity.opcua.client.gateway.datastore.DataStore;
import com.cumulocity.opcua.client.gateway.datastore.MapDbHTreeMapDataStore;
import com.cumulocity.opcua.client.gateway.datastore.MapDbWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import net.openhft.chronicle.map.ChronicleMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DatabaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfiguration.class);
    private static final String DB_FILE_NAME = "cumulocity-opcua-gateway.db";
    private static final String TMP_DB_FILE_NAME = "cumulocity-opcua-gateway.db.tmp";
    public static final String SERVER_ADDRESS_SPACE_FILE_NAME_W_PROSYS_V3 = "cumulocity-opcua-server-%s-address-space.bin";
    public static final String SERVER_ADDRESS_SPACE_FILE_NAME_W_PROSYS_V4 = "cumulocity-opcua-server-%s-address-space-pv4.bin";
    @Value(value="${gateway.db.baseDir:${user.home}/.opcua/data}")
    private String databasePath;
    private DB db = null;
    @Value(value="${gateway.mappingExecution.alarmStatusStore.maxEntries:100000}")
    private String maxEntries;
    @Value(value="${gateway.mappingExecution.alarmStatusStore.averageKeySize:30}")
    private String averageKeySize;
    @Value(value="${gateway.mappingExecution.alarmStatusStore.maxBloatFactor:5.0}")
    private String maxBloatFactor;
    private ChronicleMap<CharSequence, Long> alarmStatusStore;
    @Value(value="${gateway.mappingExecution.deviceTypeMappingStore.maxServerMappingsEntries:10}")
    private String maxServerMappingsEntries;
    @Value(value="${gateway.mappingExecution.deviceTypeMappingStore.averageMappingsKeySize:8}")
    private String averageMappingsKeySize;
    @Value(value="${gateway.mappingExecution.deviceTypeMappingStore.averageMappingsValueSize:4194304}")
    private String averageMappingsValueSize;
    @Value(value="${gateway.mappingExecution.deviceTypeMappingStore.maxMappingsBloatFactor:5.0}")
    private String maxMappingsBloatFactor;
    private ChronicleMap<String, DeviceTypeMappedNodeCollection> deviceTypeMappingStore;
    @Value(value="${gateway.db.addressSpace.legacyCleanup:true}")
    private boolean cleanupLegacyAddressSpaceLocalDb;

    @Bean
    @Primary
    public MapDbWrapper database() {
        this.createBaseDirIfNotExist();
        File dbFile = Paths.get(this.databasePath, DB_FILE_NAME).toFile();
        this.db = DBMaker.fileDB((File)dbFile).fileLockDisable().checksumHeaderBypass().make();
        MapDbWrapper dbWrapper = new MapDbWrapper(this.db, dbFile);
        if (dbWrapper.exists("executedOperations")) {
            return this.replaceDatabase(dbFile);
        }
        return dbWrapper;
    }

    @Deprecated
    private MapDbWrapper replaceDatabase(File dbFile) {
        log.info("Start migrating gateway data from existing DB file.");
        File tmpDbFile = Paths.get(this.databasePath, TMP_DB_FILE_NAME).toFile();
        DB tmpDb = DBMaker.fileDB((File)tmpDbFile).fileLockDisable().checksumHeaderBypass().make();
        for (String mapName : this.db.getAll().keySet()) {
            if (mapName.equals("executedOperations")) continue;
            log.info("Migrating map {}", (Object)mapName);
            HTreeMap newMap = tmpDb.hashMap(mapName).createOrOpen();
            HTreeMap oldMap = this.db.hashMap(mapName).createOrOpen();
            newMap.putAll(oldMap);
        }
        tmpDb.commit();
        log.info("Removing old file of size {} bytes", (Object)dbFile.length());
        if (dbFile.delete()) {
            log.info("Old file has been successfully removed, replacing with new DB file of size {} bytes", (Object)tmpDbFile.length());
            tmpDbFile.renameTo(dbFile);
        }
        this.db = tmpDb;
        log.info("Successfully migrated gateway data.");
        return new MapDbWrapper(this.db, tmpDbFile);
    }

    private void createBaseDirIfNotExist() {
        File baseDir = new File(this.databasePath);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
    }

    @Bean(name={"gatewayDataStore"})
    @Primary
    public DataStore mapDbDataStore() {
        return new MapDbHTreeMapDataStore(this.database());
    }

    @Bean(name={"addressSpaceFileDataStore"})
    public DataStore addressSpaceFileDataStore() {
        this.createBaseDirIfNotExist();
        return new AddressSpaceFileDataStore(this.databasePath, this.cleanupLegacyAddressSpaceLocalDb);
    }

    @Bean(name={"alarmStatusStore"})
    public ChronicleMap<CharSequence, Long> alarmStatusStore() {
        this.createBaseDirIfNotExist();
        try {
            File persistentFile = new File(this.databasePath + "/alarmStatus.dat");
            log.info("Alarm store: {}", (Object)persistentFile.getAbsoluteFile());
            log.info("ChronicleMap configuration: averageKeySize: {}, maxBloatFactor: {}, entries: {}", new Object[]{this.averageKeySize, this.maxBloatFactor, this.maxEntries});
            this.alarmStatusStore = ChronicleMap.of(CharSequence.class, Long.class).name("alarmstatus-map").averageKeySize(Double.parseDouble(this.averageKeySize)).maxBloatFactor(Double.parseDouble(this.maxBloatFactor)).entries(Long.parseLong(this.maxEntries)).createOrRecoverPersistedTo(persistentFile);
            log.info("Created alarm status storage with size {}, off heap usage of {} bytes and current free space of {}%", new Object[]{this.alarmStatusStore.size(), this.alarmStatusStore.offHeapMemoryUsed(), this.alarmStatusStore.percentageFreeSpace()});
        }
        catch (IOException ioe) {
            log.error("Cannot initialize alarmStatus database", (Throwable)ioe);
        }
        return this.alarmStatusStore;
    }

    @Bean(name={"deviceTypeMappingStore"})
    public ChronicleMap<String, DeviceTypeMappedNodeCollection> deviceTypeMappingStore() {
        this.createBaseDirIfNotExist();
        try {
            File persistentFile = new File(this.databasePath + "/deviceTypeMapping.dat");
            log.info("Mapping store: {}", (Object)persistentFile.getAbsoluteFile());
            log.info("ChronicleMap configuration: averageKeySize: {}, averageValueSize: {}, maxBloatFactor: {}, entries: {}", new Object[]{this.averageMappingsKeySize, this.averageMappingsValueSize, this.maxMappingsBloatFactor, this.maxServerMappingsEntries});
            this.deviceTypeMappingStore = ChronicleMap.of(String.class, DeviceTypeMappedNodeCollection.class).name("deviceType-map").averageKeySize(Double.parseDouble(this.averageMappingsKeySize)).averageValueSize(Double.parseDouble(this.averageMappingsValueSize)).maxBloatFactor(Double.parseDouble(this.maxMappingsBloatFactor)).entries(Long.parseLong(this.maxServerMappingsEntries)).createOrRecoverPersistedTo(persistentFile);
            log.info("Created deviceTypeMapping storage with size {}, off heap usage of {} bytes and current free space of {}%", new Object[]{this.deviceTypeMappingStore.size(), this.deviceTypeMappingStore.offHeapMemoryUsed(), this.deviceTypeMappingStore.percentageFreeSpace()});
        }
        catch (IOException ioe) {
            log.error("Cannot initialize deviceTypeMapping database", (Throwable)ioe);
        }
        return this.deviceTypeMappingStore;
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public void setMaxEntries(String maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setAverageKeySize(String averageKeySize) {
        this.averageKeySize = averageKeySize;
    }

    public void setMaxBloatFactor(String maxBloatFactor) {
        this.maxBloatFactor = maxBloatFactor;
    }

    public void setMaxServerMappingsEntries(String maxServerMappingsEntries) {
        this.maxServerMappingsEntries = maxServerMappingsEntries;
    }

    public void setAverageMappingsKeySize(String averageMappingsKeySize) {
        this.averageMappingsKeySize = averageMappingsKeySize;
    }

    public void setAverageMappingsValueSize(String averageMappingsValueSize) {
        this.averageMappingsValueSize = averageMappingsValueSize;
    }

    public void setMaxMappingsBloatFactor(String maxMappingsBloatFactor) {
        this.maxMappingsBloatFactor = maxMappingsBloatFactor;
    }
}

